/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

public class ByteSequence {
    public byte[] data;
    public int offset;
    public int length;

    public ByteSequence() {
    }

    public ByteSequence(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    public ByteSequence(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void compact() {
        if (this.length != this.data.length) {
            byte[] t = new byte[this.length];
            System.arraycopy(this.data, this.offset, t, 0, this.length);
            this.data = t;
            this.offset = 0;
        }
    }

    public ByteSequence copy() {
        byte[] dst = new byte[this.data.length];
        System.arraycopy(this.data, 0, dst, 0, this.data.length);
        ByteSequence bs = new ByteSequence();
        bs.setData(dst);
        bs.setOffset(this.offset);
        bs.setLength(this.length);
        return bs;
    }

    public ByteSequence compactCopy() {
        if (this.length != this.data.length) {
            byte[] dst = new byte[this.length];
            System.arraycopy(this.data, this.offset, dst, 0, this.length);
            ByteSequence bs = new ByteSequence();
            bs.setData(dst);
            bs.setOffset(0);
            bs.setLength(this.length);
            return bs;
        }
        return this.copy();
    }
}

