/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private static final ClassLoader FALLBACK_CLASS_LOADER = ClassLoadingAwareObjectInputStream.class.getClassLoader();
    private static final HashMap<String, Class> primClasses = new HashMap(8, 1.0f);
    private final ClassLoader inLoader;

    public ClassLoadingAwareObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.inLoader = in.getClass().getClassLoader();
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.load(classDesc.getName(), cl, this.inLoader);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.load(interfaces[i], cl);
        }
        try {
            return Proxy.getProxyClass(cl, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            try {
                return Proxy.getProxyClass(this.inLoader, cinterfaces);
            }
            catch (IllegalArgumentException e1) {
                try {
                    return Proxy.getProxyClass(FALLBACK_CLASS_LOADER, cinterfaces);
                }
                catch (IllegalArgumentException e2) {
                    throw new ClassNotFoundException(null, e);
                }
            }
        }
    }

    private Class<?> load(String className, ClassLoader ... cl) throws ClassNotFoundException {
        for (ClassLoader loader : cl) {
            try {
                return Class.forName(className, false, loader);
            }
            catch (ClassNotFoundException e) {
            }
        }
        Class clazz = primClasses.get(className);
        if (clazz != null) {
            return clazz;
        }
        return Class.forName(className, false, FALLBACK_CLASS_LOADER);
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

