/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class FileUtils {
    public static void string2File(String str, String fileName) throws IOException {
        FileUtils.string2File(str, fileName, false);
    }

    public static void string2File(String str, String fileName, boolean force) throws IOException {
        if (force) {
            String prevContent = FileUtils.file2String(fileName);
            if (str.equals(prevContent)) {
                return;
            }
            if (prevContent != null) {
                String bakFile = fileName + ".bak";
                FileUtils.string2FileSafe(prevContent, bakFile);
            }
            FileUtils.string2FileSafe(str, fileName);
        } else {
            String tmpFile = fileName + ".tmp";
            FileUtils.string2FileNotSafe(str, tmpFile);
            String bakFile = fileName + ".bak";
            String prevContent = FileUtils.file2String(fileName);
            if (str.equals(prevContent)) {
                return;
            }
            if (prevContent != null) {
                FileUtils.string2FileNotSafe(prevContent, bakFile);
            }
            File file = new File(fileName);
            file.delete();
            file = new File(tmpFile);
            file.renameTo(new File(fileName));
        }
    }

    public static void string2FileNotSafe(String str, String fileName) throws IOException {
        File file = new File(fileName);
        File fileParent = file.getParentFile();
        if (fileParent != null) {
            fileParent.mkdirs();
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(str);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void string2FileSafe(String str, String fileName) throws IOException {
        File file = new File(fileName);
        File fileParent = file.getParentFile();
        if (fileParent != null) {
            fileParent.mkdirs();
        }
        FileOutputStream fos = null;
        ByteBuffer buff = ByteBuffer.wrap(str.getBytes());
        try {
            fos = new FileOutputStream(file);
            FileChannel channel = fos.getChannel();
            channel.write(buff);
            channel.force(false);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static String file2String(String fileName) throws IOException {
        File file = new File(fileName);
        return FileUtils.file2String(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(File file) throws IOException {
        if (file.exists()) {
            boolean result;
            byte[] data = new byte[(int)file.length()];
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                int len = inputStream.read(data);
                result = len == data.length;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (result) {
                return new String(data);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(URL url) {
        InputStream in = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            in = urlConnection.getInputStream();
            int len = in.available();
            byte[] data = new byte[len];
            in.read(data, 0, len);
            String string = new String(data, "UTF-8");
            return string;
        }
        catch (Exception ignored) {
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }
}

