/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

import com.bes.mq.util.LRUCache;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final Object IGNORE = new Object();
    private final LRUCache cache;

    public LRUSet() {
        this(0, 10000, 0.75f, true);
    }

    public LRUSet(int maximumCacheSize) {
        this(0, maximumCacheSize, 0.75f, true);
    }

    public LRUSet(int initialCapacity, int maximumCacheSize, float loadFactor, boolean accessOrder) {
        this.cache = new LRUCache(initialCapacity, maximumCacheSize, loadFactor, accessOrder);
    }

    @Override
    public Iterator<E> iterator() {
        return this.cache.keySet().iterator();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.cache.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.cache.put(o, IGNORE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.cache.remove(o) == IGNORE;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

