/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.transport.LogWriter;
import com.bes.mq.transport.TransportLoggerView;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class LogWriterFinder {
    private static final Logger log = LoggerFactory.getLogger(TransportLoggerView.class);
    private final String path;
    private final ConcurrentHashMap classMap = new ConcurrentHashMap();

    public LogWriterFinder(String path) {
        this.path = path;
    }

    public LogWriter newInstance(String logWriterName) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class clazz = (Class)this.classMap.get(logWriterName);
        if (clazz == null) {
            clazz = this.newInstance(this.doFindLogWriterProperties(logWriterName));
            this.classMap.put(logWriterName, clazz);
        }
        return (LogWriter)clazz.newInstance();
    }

    private Class newInstance(Properties properties) throws ClassNotFoundException, IOException {
        Class<?> clazz;
        String className = properties.getProperty("class");
        if (className == null) {
            throw new IOException("Expected property is missing: class");
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            clazz = LogWriterFinder.class.getClassLoader().loadClass(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties doFindLogWriterProperties(String logWriterName) throws IOException {
        Properties properties;
        InputStream in;
        String uri = this.path + logWriterName;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((in = classLoader.getResourceAsStream(uri)) == null && (in = LogWriterFinder.class.getClassLoader().getResourceAsStream(uri)) == null) {
            log.error("Could not find log writer for resource: " + uri);
            throw new IOException("Could not find log writer for resource: " + uri);
        }
        BufferedInputStream reader = null;
        Properties properties2 = new Properties();
        try {
            reader = new BufferedInputStream(in);
            properties2.load(reader);
            properties = properties2;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                reader.close();
            }
            catch (Exception e) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return properties;
    }
}

