/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import java.security.MessageDigest;

public class MD5Util {
    private static Logger logger = LoggerFactory.getLogger(MD5Util.class);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final byte[] md5Byte(byte[] bytes) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(bytes);
            bytes = md5.digest();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return bytes;
    }

    public static final String md5Str(String str) {
        try {
            byte[] bs = str.getBytes();
            return MD5Util.getFormattedText(MD5Util.md5Byte(bs));
        }
        catch (Exception ex) {
            return str;
        }
    }

    public static final String md5Str(String str, String encoding) {
        try {
            byte[] bs = str.getBytes(encoding);
            return MD5Util.getFormattedText(MD5Util.md5Byte(bs));
        }
        catch (Exception ex) {
            return str;
        }
    }

    public static String getFormattedText(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int j = 0; j < bytes.length; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }
}

