/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

import com.bes.mq.Service;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.util.ServiceListener;
import com.bes.mq.util.ServiceStopper;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ServiceSupport
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceSupport.class);
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private List<ServiceListener> serviceListeners = new CopyOnWriteArrayList<ServiceListener>();

    public static void dispose(Service service) {
        try {
            service.stop();
        }
        catch (Exception e) {
            LOG.debug("Could not stop service: " + service + ". Reason: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            boolean success = false;
            this.stopped.set(false);
            try {
                this.preStart();
                this.doStart();
                success = true;
            }
            finally {
                this.started.set(success);
            }
            for (ServiceListener l : this.serviceListeners) {
                l.started(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.stopped.compareAndSet(false, true)) {
            this.stopping.set(true);
            ServiceStopper stopper = new ServiceStopper();
            try {
                this.doStop(stopper);
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
            finally {
                this.postStop(stopper);
            }
            this.stopped.set(true);
            this.started.set(false);
            this.stopping.set(false);
            for (ServiceListener l : this.serviceListeners) {
                l.stopped(this);
            }
            stopper.throwFirstException();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public void addServiceListener(ServiceListener l) {
        this.serviceListeners.add(l);
    }

    public void removeServiceListener(ServiceListener l) {
        this.serviceListeners.remove(l);
    }

    protected void postStop(ServiceStopper stopper) throws Exception {
    }

    protected abstract void doStop(ServiceStopper var1) throws Exception;

    protected void preStart() throws Exception {
    }

    protected abstract void doStart() throws Exception;
}

