/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

import com.bes.mq.command.BESMQDestination;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToListOfBESMQDestinationConverter {
    public static List<BESMQDestination> convertToBESMQDestination(Object value) {
        if (value == null) {
            return null;
        }
        String text = value.toString();
        if (text.startsWith("[") && text.endsWith("]")) {
            text = text.substring(1, text.length() - 1);
            String[] array = StringUtils.delimitedListToStringArray((String)text, (String)",", null);
            ArrayList<BESMQDestination> list = new ArrayList<BESMQDestination>();
            for (String item : array) {
                list.add(BESMQDestination.createDestination(item.trim(), (byte)1));
            }
            return list;
        }
        return null;
    }

    public static String convertFromBESMQDestination(Object value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("[");
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!(e instanceof BESMQDestination)) continue;
                BESMQDestination destination = (BESMQDestination)e;
                sb.append(destination);
                if (i >= list.size() - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("]");
        if (sb.length() > 2) {
            return sb.toString();
        }
        return null;
    }
}

