/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util;

import com.bes.mq.broker.ConnectionContext;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.store.PersistenceAdapter;
import com.bes.mq.util.Callback;
import com.bes.mq.util.IOExceptionSupport;
import java.io.IOException;

public class TransactionTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionTemplate.class);
    private PersistenceAdapter persistenceAdapter;
    private ConnectionContext context;

    public TransactionTemplate(PersistenceAdapter persistenceAdapter, ConnectionContext context) {
        this.persistenceAdapter = persistenceAdapter;
        this.context = context;
    }

    public void run(Callback task) throws IOException {
        this.persistenceAdapter.beginTransaction(this.context);
        Throwable throwable = null;
        try {
            task.execute();
        }
        catch (IOException t) {
            throwable = t;
            throw t;
        }
        catch (RuntimeException t) {
            throwable = t;
            throw t;
        }
        catch (Throwable t) {
            throwable = t;
            throw IOExceptionSupport.create("Persistence task failed: " + t, t);
        }
        finally {
            if (throwable == null) {
                this.persistenceAdapter.commitTransaction(this.context);
            } else {
                LOG.error("Having to Rollback - caught an exception: " + throwable);
                this.persistenceAdapter.rollbackTransaction(this.context);
            }
        }
    }

    public ConnectionContext getContext() {
        return this.context;
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.persistenceAdapter;
    }
}

