/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util.oxm;

import com.bes.mq.util.oxm.AbstractXMLMessageTransformer;
import java.io.StringReader;
import java.io.StringWriter;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.oxm.support.AbstractMarshaller;

public class OXMMessageTransformer
extends AbstractXMLMessageTransformer {
    private AbstractMarshaller marshaller;

    public AbstractMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(AbstractMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    protected String marshall(Session session, ObjectMessage objectMessage) throws JMSException {
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            this.marshaller.marshal((Object)objectMessage.getObject(), (Result)result);
            writer.flush();
            return writer.toString();
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
    }

    @Override
    protected Object unmarshall(Session session, TextMessage textMessage) throws JMSException {
        try {
            String text = textMessage.getText();
            StreamSource source = new StreamSource(new StringReader(text));
            return this.marshaller.unmarshal((Source)source);
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
    }
}

