/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.util.oxm;

import com.bes.mq.com.thoughtworks.xstream.XStream;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.bes.mq.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.bes.mq.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.bes.mq.com.thoughtworks.xstream.io.xml.XppReader;
import com.bes.mq.org.xmlpull.mxp1.MXParser;
import com.bes.mq.util.oxm.AbstractXMLMessageTransformer;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;

public class XStreamMessageTransformer
extends AbstractXMLMessageTransformer {
    private XStream xStream;
    private HierarchicalStreamDriver streamDriver;

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    public HierarchicalStreamDriver getStreamDriver() {
        return this.streamDriver;
    }

    public void setStreamDriver(HierarchicalStreamDriver streamDriver) {
        this.streamDriver = streamDriver;
    }

    protected XStream createXStream() {
        return new XStream();
    }

    @Override
    protected String marshall(Session session, ObjectMessage objectMessage) throws JMSException {
        Serializable object = objectMessage.getObject();
        StringWriter buffer = new StringWriter();
        HierarchicalStreamWriter out = this.streamDriver != null ? this.streamDriver.createWriter(buffer) : new PrettyPrintWriter(buffer);
        this.getXStream().marshal(object, out);
        return buffer.toString();
    }

    @Override
    protected Object unmarshall(Session session, TextMessage textMessage) throws JMSException {
        HierarchicalStreamReader in = this.streamDriver != null ? this.streamDriver.createReader(new StringReader(textMessage.getText())) : new XppReader((Reader)new StringReader(textMessage.getText()), new MXParser());
        return this.getXStream().unmarshal(in);
    }
}

