/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.xbean;

import com.bes.mq.broker.BrokerFactoryHandler;
import com.bes.mq.broker.BrokerService;
import com.bes.mq.org.slf4j.Logger;
import com.bes.mq.org.slf4j.LoggerFactory;
import com.bes.mq.spring.Utils;
import com.bes.mq.util.IntrospectionSupport;
import com.bes.mq.util.URISupport;
import java.beans.PropertyEditorManager;
import java.net.MalformedURLException;
import java.net.URI;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.apache.xbean.spring.context.impl.URIEditor;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class XBeanBrokerFactory
implements BrokerFactoryHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(XBeanBrokerFactory.class);
    private boolean validate = true;

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public BrokerService createBroker(URI config) throws Exception {
        String uri = config.getSchemeSpecificPart();
        if (uri.lastIndexOf(63) != -1) {
            IntrospectionSupport.setProperties(this, URISupport.parseQuery(uri));
            uri = uri.substring(0, uri.lastIndexOf(63));
        }
        ApplicationContext context = this.createApplicationContext(uri);
        BrokerService broker = null;
        try {
            broker = (BrokerService)context.getBean("broker");
        }
        catch (BeansException e) {
            // empty catch block
        }
        if (broker == null) {
            String name;
            String[] names = context.getBeanNamesForType(BrokerService.class);
            for (int i = 0; i < names.length && (broker = (BrokerService)context.getBean(name = names[i])) == null; ++i) {
            }
        }
        if (broker == null) {
            throw new IllegalArgumentException("The configuration has no BrokerService instance for resource: " + config);
        }
        if (broker instanceof ApplicationContextAware) {
            ((ApplicationContextAware)broker).setApplicationContext(context);
        }
        return broker;
    }

    protected ApplicationContext createApplicationContext(String uri) throws MalformedURLException {
        Resource resource = Utils.resourceFromString(uri);
        LOG.debug("Using " + resource + " from " + uri);
        try {
            return new ResourceXmlApplicationContext(resource){

                protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
                    reader.setValidating(XBeanBrokerFactory.this.isValidate());
                }
            };
        }
        catch (FatalBeanException errorToLog) {
            LOG.error("Failed to load: " + resource + ", reason: " + errorToLog.getLocalizedMessage(), errorToLog);
            throw errorToLog;
        }
    }

    static {
        PropertyEditorManager.registerEditor(URI.class, URIEditor.class);
    }
}

