/*
 * Decompiled with CFR 0.152.
 */
package com.bes.mq.xbean;

import com.bes.mq.broker.BrokerService;
import com.bes.mq.usage.SystemUsage;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.CachedIntrospectionResults;

public class XBeanBrokerService
extends BrokerService {
    private boolean start = true;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.ensureSystemUsageHasStore();
        if (this.shouldAutostart()) {
            this.start();
        }
    }

    protected boolean shouldAutostart() {
        return this.start;
    }

    private void ensureSystemUsageHasStore() throws IOException {
        SystemUsage usage = this.getSystemUsage();
        if (usage.getStoreUsage().getStore() == null) {
            usage.getStoreUsage().setStore(this.getPersistenceAdapter());
        }
        if (usage.getTempUsage().getStore() == null) {
            usage.getTempUsage().setStore(this.getTempDataStore());
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.stop();
    }

    public void stop() throws Exception {
        CachedIntrospectionResults.clearClassLoader((ClassLoader)this.getClass().getClassLoader());
        super.stop();
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

