/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.core.web.jade;

import com.bes.org.mozilla.javascript.ErrorReporter;
import com.bes.org.mozilla.javascript.EvaluatorException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultErrorReporter
implements ErrorReporter {
    private static final int MAX_MSG_LENGTH = 64;
    private Logger rootLogger = null;
    private boolean logEnable = false;

    public DefaultErrorReporter(Logger rootLogger) {
        this.rootLogger = rootLogger;
    }

    @Override
    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.logEnable) {
            message = DefaultErrorReporter.trimMessage(message, 64);
            if (line < 0) {
                this.rootLogger.log(Level.WARNING, "HtmlCompressor[WARNING]: \"" + message + "\" during JavaScript compression");
            } else {
                this.rootLogger.log(Level.WARNING, "HtmlCompressor[WARNING]: \"" + message + "\" at line [" + line + ":" + lineOffset + "] during JavaScript compression" + (lineSource != null ? ": " + lineSource : ""));
            }
        }
    }

    @Override
    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.logEnable) {
            message = DefaultErrorReporter.trimMessage(message, 64);
            if (line < 0) {
                this.rootLogger.log(Level.WARNING, "HtmlCompressor[ERROR]: \"" + message + "\" during JavaScript compression");
            } else {
                this.rootLogger.log(Level.WARNING, "HtmlCompressor[ERROR]: \"" + message + "\" at line [" + line + ":" + lineOffset + "] during JavaScript compression" + (lineSource != null ? ": " + lineSource : ""));
            }
        }
    }

    @Override
    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message);
    }

    private static String trimMessage(String msg, int len) {
        if (msg != null && msg.length() > 0) {
            int end = Math.min(msg.length(), len);
            return msg.substring(0, end);
        }
        return msg;
    }

    public boolean isLogEnable() {
        return this.logEnable;
    }

    public void setLogEnable(boolean logEnable) {
        this.logEnable = logEnable;
    }
}

