/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.core.web.jade;

import com.bes.enterprise.core.web.jade.CssJader;
import com.bes.enterprise.core.web.jade.DefaultErrorReporter;
import com.bes.enterprise.core.web.jade.HtmlJaderStatistics;
import com.bes.enterprise.core.web.jade.Jader;
import com.bes.enterprise.core.web.jade.JavaScriptJader;
import com.bes.org.mozilla.javascript.ErrorReporter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlJader
implements Jader {
    private static final Logger logger = Logger.getLogger(HtmlJader.class.getName());
    private static final Pattern PHP_TAG_PATTERN = Pattern.compile("<\\?php.*?\\?>", 34);
    public static final Pattern SERVER_SCRIPT_TAG_PATTERN = Pattern.compile("<%.*?%>", 32);
    public static final Pattern SERVER_SIDE_INCLUDE_PATTERN = Pattern.compile("<!--\\s*#.*?-->", 32);
    private static final String BLOCK_TAGS_MIN = "html,head,body,br,p";
    private static final String BLOCK_TAGS_MAX = "html,head,body,br,p,h1,h2,h3,h4,h5,h6,blockquote,center,dl,fieldset,form,frame,frameset,hr,noframes,ol,table,tbody,tr,td,th,tfoot,thead,ul";
    private static final String ALL_TAGS = "all";
    private boolean enabled = true;
    private Jader javaScriptCompressor = null;
    private Jader cssCompressor = null;
    private boolean removeComments = true;
    private boolean removeMultiSpaces = true;
    private boolean removeJsJavaComments = false;
    private boolean removeTagLinebreaks = false;
    private boolean removeIntertagSpaces = false;
    private boolean removeQuotes = false;
    private boolean compressJavaScript = false;
    private boolean compressCss = false;
    private boolean simpleDoctype = false;
    private boolean removeScriptAttributes = false;
    private boolean removeStyleAttributes = false;
    private boolean removeLinkAttributes = false;
    private boolean removeFormAttributes = false;
    private boolean removeInputAttributes = false;
    private boolean simpleBooleanAttributes = false;
    private boolean removeJavaScriptProtocol = false;
    private boolean removeHttpProtocol = false;
    private boolean removeHttpsProtocol = false;
    private boolean preserveLineBreaks = false;
    private String removeSurroundingSpaces = null;
    private boolean logEnable = false;
    private List<Pattern> preservePatterns = null;
    private boolean generateStatistics = false;
    private HtmlJaderStatistics statistics = null;
    private boolean yuiJsNoMunge = false;
    private boolean yuiJsPreserveAllSemiColons = false;
    private boolean yuiJsDisableOptimizations = false;
    private int yuiJsLineBreak = -1;
    private int yuiCssLineBreak = -1;
    private ErrorReporter yuiErrorReporter = new DefaultErrorReporter(logger);
    private static final String tempCondCommentBlock = "%%%~COMPRESS~COND~{0,number,#}~%%%";
    private static final String tempPreBlock = "%%%~COMPRESS~PRE~{0,number,#}~%%%";
    private static final String tempTextAreaBlock = "%%%~COMPRESS~TEXTAREA~{0,number,#}~%%%";
    private static final String tempScriptBlock = "%%%~COMPRESS~SCRIPT~{0,number,#}~%%%";
    private static final String tempStyleBlock = "%%%~COMPRESS~STYLE~{0,number,#}~%%%";
    private static final String tempEventBlock = "%%%~COMPRESS~EVENT~{0,number,#}~%%%";
    private static final String tempLineBreakBlock = "%%%~COMPRESS~LT~{0,number,#}~%%%";
    private static final String tempSkipBlock = "%%%~COMPRESS~SKIP~{0,number,#}~%%%";
    private static final String tempUserBlock = "%%%~COMPRESS~USER{0,number,#}~{1,number,#}~%%%";
    private static final Pattern emptyPattern = Pattern.compile("\\s");
    private static final Pattern skipPattern = Pattern.compile("<!--\\s*\\{\\{\\{\\s*-->(.*?)<!--\\s*\\}\\}\\}\\s*-->", 34);
    private static final Pattern condCommentPattern = Pattern.compile("(<!(?:--)?\\[[^\\]]+?]>)(.*?)(<!\\[[^\\]]+]-->)", 34);
    private static final Pattern commentPattern = Pattern.compile("<!---->|<!--[^\\[].*?-->", 34);
    private static final Pattern jsJavaLineCommentPattern = Pattern.compile("^\\s*?//.*?$", 10);
    private static final Pattern jsJavaBlockCommentPattern = Pattern.compile("^\\s*?/\\*((?!(\\*/)).)*?\\*/\\s*?$", 42);
    private static final Pattern intertagPattern_TagTag = Pattern.compile(">\\s+<", 34);
    private static final Pattern intertagPattern_TagCustom = Pattern.compile(">\\s+%%%~", 34);
    private static final Pattern intertagPattern_CustomTag = Pattern.compile("~%%%\\s+<", 34);
    private static final Pattern intertagPattern_CustomCustom = Pattern.compile("~%%%\\s+%%%~", 34);
    private static final Pattern multiLinePattern = Pattern.compile("\\s*[\r\n]+");
    private static final Pattern multispacePattern = Pattern.compile("\\p{Blank}+");
    private static final Pattern tagEndSpacePattern = Pattern.compile("(<(?:[^>]+?))(?:\\s+?)(/?>)", 34);
    private static final Pattern tagLastUnquotedValuePattern = Pattern.compile("=\\s*[a-z0-9-_]+$", 2);
    private static final Pattern tagQuotePattern = Pattern.compile("\\s*=\\s*([\"'])([a-z0-9-_]+?)\\1(/?)(?=[^<]*?>)", 2);
    private static final Pattern prePattern = Pattern.compile("(<pre[^>]*?>)(.*?)(</pre>)", 34);
    private static final Pattern taPattern = Pattern.compile("(<textarea[^>]*?>)(.*?)(</textarea>)", 34);
    private static final Pattern scriptPattern = Pattern.compile("(<script(((?!(src\\s*?=))[^>])*?)>)(.*?)(</script>)", 34);
    private static final Pattern stylePattern = Pattern.compile("(<style[^>]*?>)(.*?)(</style>)", 34);
    private static final Pattern tagPropertyPattern = Pattern.compile("(\\s\\w+)\\s*=\\s*(?=[^<]*?>)", 2);
    private static final Pattern cdataPattern = Pattern.compile("\\s*<!\\[CDATA\\[(.*?)\\]\\]>\\s*", 34);
    private static final Pattern doctypePattern = Pattern.compile("<!DOCTYPE[^>]*>", 34);
    private static final Pattern typeAttrPattern = Pattern.compile("type\\s*=\\s*([\\\"']*)(.+?)\\1", 34);
    private static final Pattern jsTypeAttrPattern = Pattern.compile("(<script[^>]*)type\\s*=\\s*([\"']*)(?:text|application)/javascript\\2([^>]*>)", 34);
    private static final Pattern jsLangAttrPattern = Pattern.compile("(<script[^>]*)language\\s*=\\s*([\"']*)javascript\\2([^>]*>)", 34);
    private static final Pattern styleTypeAttrPattern = Pattern.compile("(<style[^>]*)type\\s*=\\s*([\"']*)text/style\\2([^>]*>)", 34);
    private static final Pattern linkTypeAttrPattern = Pattern.compile("(<link[^>]*)type\\s*=\\s*([\"']*)text/(?:css|plain)\\2([^>]*>)", 34);
    private static final Pattern linkRelAttrPattern = Pattern.compile("<link(?:[^>]*)rel\\s*=\\s*([\"']*)(?:alternate\\s+)?stylesheet\\1(?:[^>]*)>", 34);
    private static final Pattern formMethodAttrPattern = Pattern.compile("(<form[^>]*)method\\s*=\\s*([\"']*)get\\2([^>]*>)", 34);
    private static final Pattern inputTypeAttrPattern = Pattern.compile("(<input[^>]*)type\\s*=\\s*([\"']*)text\\2([^>]*>)", 34);
    private static final Pattern booleanAttrPattern = Pattern.compile("(<\\w+[^>]*)(checked|selected|disabled|readonly)\\s*=\\s*([\"']*)\\w*\\3([^>]*>)", 34);
    private static final Pattern eventJsProtocolPattern = Pattern.compile("^javascript:\\s*(.+)", 34);
    private static final Pattern httpProtocolPattern = Pattern.compile("(<[^>]+?(?:href|src|cite|action)\\s*=\\s*['\"])http:(//[^>]+?>)", 34);
    private static final Pattern httpsProtocolPattern = Pattern.compile("(<[^>]+?(?:href|src|cite|action)\\s*=\\s*['\"])https:(//[^>]+?>)", 34);
    private static final Pattern relExternalPattern = Pattern.compile("<(?:[^>]*)rel\\s*=\\s*([\"']*)(?:alternate\\s+)?external\\1(?:[^>]*)>", 34);
    private static final Pattern eventPattern1 = Pattern.compile("(\\son[a-z]+\\s*=\\s*\")([^\"\\\\\\r\\n]*(?:\\\\.[^\"\\\\\\r\\n]*)*)(\")", 2);
    private static final Pattern eventPattern2 = Pattern.compile("(\\son[a-z]+\\s*=\\s*')([^'\\\\\\r\\n]*(?:\\\\.[^'\\\\\\r\\n]*)*)(')", 2);
    private static final Pattern lineBreakPattern = Pattern.compile("(?:\\p{Blank}*(\\r?\\n)\\p{Blank}*)+");
    private static final Pattern surroundingSpacesMinPattern = Pattern.compile("\\s*(</?(?:" + "html,head,body,br,p".replaceAll(",", "|") + ")(?:>|[\\s/][^>]*>))\\s*", 34);
    private static final Pattern surroundingSpacesMaxPattern = Pattern.compile("\\s*(</?(?:" + "html,head,body,br,p,h1,h2,h3,h4,h5,h6,blockquote,center,dl,fieldset,form,frame,frameset,hr,noframes,ol,table,tbody,tr,td,th,tfoot,thead,ul".replaceAll(",", "|") + ")(?:>|[\\s/][^>]*>))\\s*", 34);
    private static final Pattern surroundingSpacesAllPattern = Pattern.compile("\\s*(<[^>]+>)\\s*", 34);
    private static final Pattern tagRemoveLinebreakPattern = Pattern.compile("^((?!//).)*?(</??(\\w)+?(:(\\w)+?)??(.*?>))\\s*?([\r\n]+)", 10);
    private static final Pattern tempCondCommentPattern = Pattern.compile("%%%~COMPRESS~COND~(\\d+?)~%%%");
    private static final Pattern tempPrePattern = Pattern.compile("%%%~COMPRESS~PRE~(\\d+?)~%%%");
    private static final Pattern tempTextAreaPattern = Pattern.compile("%%%~COMPRESS~TEXTAREA~(\\d+?)~%%%");
    private static final Pattern tempScriptPattern = Pattern.compile("%%%~COMPRESS~SCRIPT~(\\d+?)~%%%");
    private static final Pattern tempStylePattern = Pattern.compile("%%%~COMPRESS~STYLE~(\\d+?)~%%%");
    private static final Pattern tempEventPattern = Pattern.compile("%%%~COMPRESS~EVENT~(\\d+?)~%%%");
    private static final Pattern tempSkipPattern = Pattern.compile("%%%~COMPRESS~SKIP~(\\d+?)~%%%");
    private static final Pattern tempLineBreakPattern = Pattern.compile("%%%~COMPRESS~LT~(\\d+?)~%%%");

    @Override
    public String jade(String html, boolean logEnable) throws Throwable {
        this.logEnable = logEnable;
        ((DefaultErrorReporter)this.yuiErrorReporter).setLogEnable(logEnable);
        if (!this.enabled || html == null || html.length() == 0) {
            return html;
        }
        try {
            this.initStatistics(html);
            ArrayList<String> condCommentBlocks = new ArrayList<String>();
            ArrayList<String> preBlocks = new ArrayList<String>();
            ArrayList<String> taBlocks = new ArrayList<String>();
            ArrayList<String> scriptBlocks = new ArrayList<String>();
            ArrayList<String> styleBlocks = new ArrayList<String>();
            ArrayList<String> eventBlocks = new ArrayList<String>();
            ArrayList<String> skipBlocks = new ArrayList<String>();
            ArrayList<String> lineBreakBlocks = new ArrayList<String>();
            ArrayList<List<String>> userBlocks = new ArrayList<List<String>>();
            html = this.preProcessHtml(html);
            html = this.preserveBlocks(html, preBlocks, taBlocks, scriptBlocks, styleBlocks, eventBlocks, condCommentBlocks, skipBlocks, lineBreakBlocks, userBlocks);
            html = this.processHtml(html);
            this.processPreservedBlocks(preBlocks, taBlocks, scriptBlocks, styleBlocks, eventBlocks, condCommentBlocks, skipBlocks, lineBreakBlocks, userBlocks);
            html = this.returnBlocks(html, preBlocks, taBlocks, scriptBlocks, styleBlocks, eventBlocks, condCommentBlocks, skipBlocks, lineBreakBlocks, userBlocks);
            html = this.postProcessHtml(html);
            this.endStatistics(html);
            return html;
        }
        catch (Throwable e) {
            if (logEnable) {
                logger.log(Level.WARNING, "Error occurred while compressing HTML.", e);
            }
            throw e;
        }
    }

    protected void initStatistics(String html) {
        if (this.generateStatistics) {
            this.statistics = new HtmlJaderStatistics();
            this.statistics.setTime(new Date().getTime());
            this.statistics.getOriginalMetrics().setFilesize(html.length());
            Matcher matcher = emptyPattern.matcher(html);
            while (matcher.find()) {
                this.statistics.getOriginalMetrics().setEmptyChars(this.statistics.getOriginalMetrics().getEmptyChars() + 1);
            }
        } else {
            this.statistics = null;
        }
    }

    protected void endStatistics(String html) {
        if (this.generateStatistics) {
            this.statistics.setTime(new Date().getTime() - this.statistics.getTime());
            this.statistics.getCompressedMetrics().setFilesize(html.length());
            Matcher matcher = emptyPattern.matcher(html);
            while (matcher.find()) {
                this.statistics.getCompressedMetrics().setEmptyChars(this.statistics.getCompressedMetrics().getEmptyChars() + 1);
            }
        }
    }

    protected String preserveBlocks(String html, List<String> preBlocks, List<String> taBlocks, List<String> scriptBlocks, List<String> styleBlocks, List<String> eventBlocks, List<String> condCommentBlocks, List<String> skipBlocks, List<String> lineBreakBlocks, List<List<String>> userBlocks) throws Throwable {
        if (this.preservePatterns != null) {
            for (int p = 0; p < this.preservePatterns.size(); ++p) {
                ArrayList<String> userBlock = new ArrayList<String>();
                Matcher matcher = this.preservePatterns.get(p).matcher(html);
                int index = 0;
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    if (matcher.group(0).trim().length() <= 0) continue;
                    userBlock.add(matcher.group(0));
                    matcher.appendReplacement(sb, MessageFormat.format(tempUserBlock, p, index++));
                }
                matcher.appendTail(sb);
                html = sb.toString();
                userBlocks.add(userBlock);
            }
        }
        Matcher matcher = skipPattern.matcher(html);
        int skipBlockIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(1).trim().length() <= 0) continue;
            skipBlocks.add(matcher.group(1));
            matcher.appendReplacement(sb, MessageFormat.format(tempSkipBlock, skipBlockIndex++));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        HtmlJader condCommentCompressor = this.createCompressorClone();
        matcher = condCommentPattern.matcher(html);
        int index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            condCommentBlocks.add(matcher.group(1) + condCommentCompressor.jade(matcher.group(2), this.logEnable) + matcher.group(3));
            matcher.appendReplacement(sb, MessageFormat.format(tempCondCommentBlock, index++));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = eventPattern1.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            eventBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, this.escape(matcher.group(1)) + MessageFormat.format(tempEventBlock, index++) + this.escape(matcher.group(3)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = eventPattern2.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            eventBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, this.escape(matcher.group(1)) + MessageFormat.format(tempEventBlock, index++) + this.escape(matcher.group(3)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = prePattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            preBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, this.escape(matcher.group(1)) + MessageFormat.format(tempPreBlock, index++) + this.escape(matcher.group(3)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = scriptPattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(5).trim().length() <= 0) continue;
            String type = "";
            Matcher typeMatcher = typeAttrPattern.matcher(matcher.group(1));
            if (typeMatcher.find()) {
                type = typeMatcher.group(2).toLowerCase();
            }
            if (type.length() == 0 || type.equals("text/javascript") || type.equals("application/javascript")) {
                scriptBlocks.add(matcher.group(5));
                matcher.appendReplacement(sb, this.escape(matcher.group(1)) + MessageFormat.format(tempScriptBlock, index++) + this.escape(matcher.group(6)));
                continue;
            }
            if (type.equals("text/x-jquery-tmpl")) continue;
            skipBlocks.add(matcher.group(5));
            matcher.appendReplacement(sb, this.escape(matcher.group(1)) + MessageFormat.format(tempSkipBlock, skipBlockIndex++) + this.escape(matcher.group(6)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = stylePattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            styleBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, this.escape(matcher.group(1)) + MessageFormat.format(tempStyleBlock, index++) + this.escape(matcher.group(3)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = taPattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            taBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, this.escape(matcher.group(1)) + MessageFormat.format(tempTextAreaBlock, index++) + this.escape(matcher.group(3)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        if (this.preserveLineBreaks) {
            matcher = lineBreakPattern.matcher(html);
            index = 0;
            sb = new StringBuffer();
            while (matcher.find()) {
                lineBreakBlocks.add(matcher.group(1));
                matcher.appendReplacement(sb, MessageFormat.format(tempLineBreakBlock, index++));
            }
            matcher.appendTail(sb);
            html = sb.toString();
        }
        return html;
    }

    protected String returnBlocks(String html, List<String> preBlocks, List<String> taBlocks, List<String> scriptBlocks, List<String> styleBlocks, List<String> eventBlocks, List<String> condCommentBlocks, List<String> skipBlocks, List<String> lineBreakBlocks, List<List<String>> userBlocks) {
        int i;
        StringBuffer sb;
        Matcher matcher;
        if (this.preserveLineBreaks) {
            matcher = tempLineBreakPattern.matcher(html);
            sb = new StringBuffer();
            while (matcher.find()) {
                i = Integer.parseInt(matcher.group(1));
                if (lineBreakBlocks.size() <= i) continue;
                matcher.appendReplacement(sb, lineBreakBlocks.get(i));
            }
            matcher.appendTail(sb);
            html = sb.toString();
        }
        matcher = tempTextAreaPattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            if (taBlocks.size() <= i) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(taBlocks.get(i)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempStylePattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            if (styleBlocks.size() <= i) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(styleBlocks.get(i)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempScriptPattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            if (scriptBlocks.size() <= i) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(scriptBlocks.get(i)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempPrePattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            if (preBlocks.size() <= i) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(preBlocks.get(i)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempEventPattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            if (eventBlocks.size() <= i) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(eventBlocks.get(i)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempCondCommentPattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            if (condCommentBlocks.size() <= i) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(condCommentBlocks.get(i)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempSkipPattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            if (skipBlocks.size() <= i) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(skipBlocks.get(i)));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        if (this.preservePatterns != null) {
            for (int p = this.preservePatterns.size() - 1; p >= 0; --p) {
                Pattern tempUserPattern = Pattern.compile("%%%~COMPRESS~USER" + p + "~(\\d+?)~%%%");
                matcher = tempUserPattern.matcher(html);
                sb = new StringBuffer();
                while (matcher.find()) {
                    int i2 = Integer.parseInt(matcher.group(1));
                    if (userBlocks.size() <= p || userBlocks.get(p).size() <= i2) continue;
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(userBlocks.get(p).get(i2)));
                }
                matcher.appendTail(sb);
                html = sb.toString();
            }
        }
        return html;
    }

    protected String processHtml(String html) {
        html = this.removeComments(html);
        html = this.simpleDoctype(html);
        html = this.removeScriptAttributes(html);
        html = this.removeStyleAttributes(html);
        html = this.removeLinkAttributes(html);
        html = this.removeFormAttributes(html);
        html = this.removeInputAttributes(html);
        html = this.simpleBooleanAttributes(html);
        html = this.removeHttpProtocol(html);
        html = this.removeHttpsProtocol(html);
        html = this.removeIntertagSpaces(html);
        html = this.removeMultiSpaces(html);
        html = this.removeSpacesInsideTags(html);
        html = this.removeQuotesInsideTags(html);
        html = this.removeSurroundingSpaces(html);
        return html.trim();
    }

    protected String removeSurroundingSpaces(String html) {
        if (this.removeSurroundingSpaces != null) {
            Pattern pattern;
            if (this.removeSurroundingSpaces.equalsIgnoreCase(BLOCK_TAGS_MIN)) {
                pattern = surroundingSpacesMinPattern;
            } else if (this.removeSurroundingSpaces.equalsIgnoreCase(BLOCK_TAGS_MAX)) {
                pattern = surroundingSpacesMaxPattern;
            }
            pattern = this.removeSurroundingSpaces.equalsIgnoreCase(ALL_TAGS) ? surroundingSpacesAllPattern : Pattern.compile("\\s*(</?(?:" + this.removeSurroundingSpaces.replaceAll(",", "|") + ")(?:>|[\\s/][^>]*>))\\s*", 34);
            Matcher matcher = pattern.matcher(html);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, "$1");
            }
            matcher.appendTail(sb);
            html = sb.toString();
        }
        return html;
    }

    protected String removeQuotesInsideTags(String html) {
        if (this.removeQuotes) {
            Matcher matcher = tagQuotePattern.matcher(html);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                if (matcher.group(3).trim().length() == 0) {
                    matcher.appendReplacement(sb, "=$2");
                    continue;
                }
                matcher.appendReplacement(sb, "=$2 $3");
            }
            matcher.appendTail(sb);
            html = sb.toString();
        }
        return html;
    }

    protected String removeSpacesInsideTags(String html) {
        html = tagPropertyPattern.matcher(html).replaceAll("$1=");
        Matcher matcher = tagEndSpacePattern.matcher(html);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).startsWith("/") && tagLastUnquotedValuePattern.matcher(matcher.group(1)).find()) {
                matcher.appendReplacement(sb, "$1 $2");
                continue;
            }
            matcher.appendReplacement(sb, "$1$2");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        return html;
    }

    protected String removeMultiSpaces(String html) {
        if (this.removeMultiSpaces) {
            html = multispacePattern.matcher(html).replaceAll(" ");
        }
        return html;
    }

    protected String removeIntertagSpaces(String html) {
        if (this.removeIntertagSpaces) {
            html = intertagPattern_TagTag.matcher(html).replaceAll("><");
            html = intertagPattern_TagCustom.matcher(html).replaceAll(">%%%~");
            html = intertagPattern_CustomTag.matcher(html).replaceAll("~%%%<");
            html = intertagPattern_CustomCustom.matcher(html).replaceAll("~%%%%%%~");
        }
        return html;
    }

    protected String removeComments(String html) {
        if (this.removeComments) {
            html = commentPattern.matcher(html).replaceAll("");
        }
        return html;
    }

    protected String removeJsJavaComments(String html) {
        if (this.removeJsJavaComments) {
            Matcher matcher = jsJavaLineCommentPattern.matcher(html);
            html = matcher.replaceAll("");
            matcher = jsJavaBlockCommentPattern.matcher(html);
            html = matcher.replaceAll("");
        }
        return html;
    }

    protected String removeTagLinebreaks(String html) {
        if (this.removeTagLinebreaks) {
            Matcher matcher = tagRemoveLinebreakPattern.matcher(html);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(buffer, this.escape(matcher.group().trim()));
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        return html;
    }

    protected String simpleDoctype(String html) {
        if (this.simpleDoctype) {
            html = doctypePattern.matcher(html).replaceAll("<!DOCTYPE html>");
        }
        return html;
    }

    protected String removeScriptAttributes(String html) {
        if (this.removeScriptAttributes) {
            html = jsTypeAttrPattern.matcher(html).replaceAll("$1$3");
            html = jsLangAttrPattern.matcher(html).replaceAll("$1$3");
        }
        return html;
    }

    protected String removeStyleAttributes(String html) {
        if (this.removeStyleAttributes) {
            html = styleTypeAttrPattern.matcher(html).replaceAll("$1$3");
        }
        return html;
    }

    protected String removeLinkAttributes(String html) {
        if (this.removeLinkAttributes) {
            Matcher matcher = linkTypeAttrPattern.matcher(html);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                if (linkRelAttrPattern.matcher(matcher.group(0)).matches()) {
                    matcher.appendReplacement(sb, "$1$3");
                    continue;
                }
                matcher.appendReplacement(sb, "$0");
            }
            matcher.appendTail(sb);
            html = sb.toString();
        }
        return html;
    }

    protected String removeFormAttributes(String html) {
        if (this.removeFormAttributes) {
            html = formMethodAttrPattern.matcher(html).replaceAll("$1$3");
        }
        return html;
    }

    protected String removeInputAttributes(String html) {
        if (this.removeInputAttributes) {
            html = inputTypeAttrPattern.matcher(html).replaceAll("$1$3");
        }
        return html;
    }

    protected String simpleBooleanAttributes(String html) {
        if (this.simpleBooleanAttributes) {
            html = booleanAttrPattern.matcher(html).replaceAll("$1$2$4");
        }
        return html;
    }

    protected String removeHttpProtocol(String html) {
        if (this.removeHttpProtocol) {
            Matcher matcher = httpProtocolPattern.matcher(html);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                if (!relExternalPattern.matcher(matcher.group(0)).matches()) {
                    matcher.appendReplacement(sb, "$1$2");
                    continue;
                }
                matcher.appendReplacement(sb, "$0");
            }
            matcher.appendTail(sb);
            html = sb.toString();
        }
        return html;
    }

    protected String removeHttpsProtocol(String html) {
        if (this.removeHttpsProtocol) {
            Matcher matcher = httpsProtocolPattern.matcher(html);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                if (!relExternalPattern.matcher(matcher.group(0)).matches()) {
                    matcher.appendReplacement(sb, "$1$2");
                    continue;
                }
                matcher.appendReplacement(sb, "$0");
            }
            matcher.appendTail(sb);
            html = sb.toString();
        }
        return html;
    }

    protected void processPreservedBlocks(List<String> preBlocks, List<String> taBlocks, List<String> scriptBlocks, List<String> styleBlocks, List<String> eventBlocks, List<String> condCommentBlocks, List<String> skipBlocks, List<String> lineBreakBlocks, List<List<String>> userBlocks) throws Throwable {
        this.processPreBlocks(preBlocks);
        this.processTextAreaBlocks(taBlocks);
        this.processScriptBlocks(scriptBlocks);
        this.processStyleBlocks(styleBlocks);
        this.processEventBlocks(eventBlocks);
        this.processCondCommentBlocks(condCommentBlocks);
        this.processSkipBlocks(skipBlocks);
        this.processUserBlocks(userBlocks);
        this.processLineBreakBlocks(lineBreakBlocks);
    }

    protected void processPreBlocks(List<String> preBlocks) {
        if (this.generateStatistics) {
            for (String block : preBlocks) {
                this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
            }
        }
    }

    protected void processTextAreaBlocks(List<String> taBlocks) {
        if (this.generateStatistics) {
            for (String block : taBlocks) {
                this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
            }
        }
    }

    protected void processCondCommentBlocks(List<String> condCommentBlocks) {
        if (this.generateStatistics) {
            for (String block : condCommentBlocks) {
                this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
            }
        }
    }

    protected void processSkipBlocks(List<String> skipBlocks) {
        if (this.generateStatistics) {
            for (String block : skipBlocks) {
                this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
            }
        }
    }

    protected void processLineBreakBlocks(List<String> lineBreakBlocks) {
        if (this.generateStatistics) {
            for (String block : lineBreakBlocks) {
                this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
            }
        }
    }

    protected void processUserBlocks(List<List<String>> userBlocks) {
        if (this.generateStatistics) {
            for (List<String> blockList : userBlocks) {
                for (String block : blockList) {
                    this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
                }
            }
        }
    }

    protected String preProcessHtml(String html) {
        html = multiLinePattern.matcher(html).replaceAll("\n");
        return html;
    }

    protected String postProcessHtml(String html) {
        html = this.removeJsJavaComments(html);
        html = this.removeTagLinebreaks(html);
        html = multiLinePattern.matcher(html).replaceAll("\n");
        return html;
    }

    protected void processEventBlocks(List<String> eventBlocks) {
        if (this.generateStatistics) {
            for (String block : eventBlocks) {
                this.statistics.getOriginalMetrics().setInlineEventSize(this.statistics.getOriginalMetrics().getInlineEventSize() + block.length());
            }
        }
        if (this.removeJavaScriptProtocol) {
            for (int i = 0; i < eventBlocks.size(); ++i) {
                eventBlocks.set(i, this.removeJavaScriptProtocol(eventBlocks.get(i)));
            }
        } else if (this.generateStatistics) {
            for (String block : eventBlocks) {
                this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
            }
        }
        if (this.generateStatistics) {
            for (String block : eventBlocks) {
                this.statistics.getCompressedMetrics().setInlineEventSize(this.statistics.getCompressedMetrics().getInlineEventSize() + block.length());
            }
        }
    }

    protected String removeJavaScriptProtocol(String source) {
        String result = source;
        Matcher matcher = eventJsProtocolPattern.matcher(source);
        if (matcher.matches()) {
            result = matcher.replaceFirst("$1");
        }
        if (this.generateStatistics) {
            this.statistics.setPreservedSize(this.statistics.getPreservedSize() + result.length());
        }
        return result;
    }

    protected void processScriptBlocks(List<String> scriptBlocks) throws Throwable {
        if (this.generateStatistics) {
            for (String block : scriptBlocks) {
                this.statistics.getOriginalMetrics().setInlineScriptSize(this.statistics.getOriginalMetrics().getInlineScriptSize() + block.length());
            }
        }
        if (this.compressJavaScript) {
            for (int i = 0; i < scriptBlocks.size(); ++i) {
                scriptBlocks.set(i, this.compressJavaScript(scriptBlocks.get(i)));
            }
        } else if (this.generateStatistics) {
            for (String block : scriptBlocks) {
                this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
            }
        }
        if (this.generateStatistics) {
            for (String block : scriptBlocks) {
                this.statistics.getCompressedMetrics().setInlineScriptSize(this.statistics.getCompressedMetrics().getInlineScriptSize() + block.length());
            }
        }
    }

    protected void processStyleBlocks(List<String> styleBlocks) throws Throwable {
        if (this.generateStatistics) {
            for (String block : styleBlocks) {
                this.statistics.getOriginalMetrics().setInlineStyleSize(this.statistics.getOriginalMetrics().getInlineStyleSize() + block.length());
            }
        }
        if (this.compressCss) {
            for (int i = 0; i < styleBlocks.size(); ++i) {
                styleBlocks.set(i, this.compressCssStyles(styleBlocks.get(i)));
            }
        } else if (this.generateStatistics) {
            for (String block : styleBlocks) {
                this.statistics.setPreservedSize(this.statistics.getPreservedSize() + block.length());
            }
        }
        if (this.generateStatistics) {
            for (String block : styleBlocks) {
                this.statistics.getCompressedMetrics().setInlineStyleSize(this.statistics.getCompressedMetrics().getInlineStyleSize() + block.length());
            }
        }
    }

    protected String compressJavaScript(String source) throws Throwable {
        if (this.javaScriptCompressor == null) {
            JavaScriptJader yuiJsCompressor = new JavaScriptJader();
            yuiJsCompressor.setNoMunge(this.yuiJsNoMunge);
            yuiJsCompressor.setPreserveAllSemiColons(this.yuiJsPreserveAllSemiColons);
            yuiJsCompressor.setDisableOptimizations(this.yuiJsDisableOptimizations);
            yuiJsCompressor.setLineBreak(this.yuiJsLineBreak);
            if (this.yuiErrorReporter != null) {
                yuiJsCompressor.setErrorReporter(this.yuiErrorReporter);
            }
            this.javaScriptCompressor = yuiJsCompressor;
        }
        boolean cdataWrapper = false;
        Matcher matcher = cdataPattern.matcher(source);
        if (matcher.matches()) {
            cdataWrapper = true;
            source = matcher.group(1);
        }
        String result = this.javaScriptCompressor.jade(source, this.logEnable);
        if (cdataWrapper) {
            result = "<![CDATA[" + result + "]]>";
        }
        return result;
    }

    protected String compressCssStyles(String source) throws Throwable {
        if (this.cssCompressor == null) {
            CssJader yuiCssCompressor = new CssJader();
            yuiCssCompressor.setLineBreak(this.yuiCssLineBreak);
            this.cssCompressor = yuiCssCompressor;
        }
        boolean cdataWrapper = false;
        Matcher matcher = cdataPattern.matcher(source);
        if (matcher.matches()) {
            cdataWrapper = true;
            source = matcher.group(1);
        }
        String result = this.cssCompressor.jade(source, this.logEnable);
        if (cdataWrapper) {
            result = "<![CDATA[" + result + "]]>";
        }
        return result;
    }

    protected HtmlJader createCompressorClone() {
        HtmlJader clone = new HtmlJader();
        clone.setJavaScriptCompressor(this.javaScriptCompressor);
        clone.setCssCompressor(this.cssCompressor);
        clone.setRemoveComments(this.removeComments);
        clone.setRemoveMultiSpaces(this.removeMultiSpaces);
        clone.setRemoveIntertagSpaces(this.removeIntertagSpaces);
        clone.setRemoveQuotes(this.removeQuotes);
        clone.setCompressJavaScript(this.compressJavaScript);
        clone.setCompressCss(this.compressCss);
        clone.setSimpleDoctype(this.simpleDoctype);
        clone.setRemoveScriptAttributes(this.removeScriptAttributes);
        clone.setRemoveStyleAttributes(this.removeStyleAttributes);
        clone.setRemoveLinkAttributes(this.removeLinkAttributes);
        clone.setRemoveFormAttributes(this.removeFormAttributes);
        clone.setRemoveInputAttributes(this.removeInputAttributes);
        clone.setSimpleBooleanAttributes(this.simpleBooleanAttributes);
        clone.setRemoveJavaScriptProtocol(this.removeJavaScriptProtocol);
        clone.setRemoveHttpProtocol(this.removeHttpProtocol);
        clone.setRemoveHttpsProtocol(this.removeHttpsProtocol);
        clone.setPreservePatterns(this.preservePatterns);
        clone.setYuiJsNoMunge(this.yuiJsNoMunge);
        clone.setYuiJsPreserveAllSemiColons(this.yuiJsPreserveAllSemiColons);
        clone.setYuiJsDisableOptimizations(this.yuiJsDisableOptimizations);
        clone.setYuiJsLineBreak(this.yuiJsLineBreak);
        clone.setYuiCssLineBreak(this.yuiCssLineBreak);
        clone.setYuiErrorReporter(this.yuiErrorReporter);
        return clone;
    }

    public boolean isCompressJavaScript() {
        return this.compressJavaScript;
    }

    public void setCompressJavaScript(boolean compressJavaScript) {
        this.compressJavaScript = compressJavaScript;
    }

    public boolean isCompressCss() {
        return this.compressCss;
    }

    public void setCompressCss(boolean compressCss) {
        this.compressCss = compressCss;
    }

    public boolean isYuiJsNoMunge() {
        return this.yuiJsNoMunge;
    }

    public void setYuiJsNoMunge(boolean yuiJsNoMunge) {
        this.yuiJsNoMunge = yuiJsNoMunge;
    }

    public boolean isYuiJsPreserveAllSemiColons() {
        return this.yuiJsPreserveAllSemiColons;
    }

    public void setYuiJsPreserveAllSemiColons(boolean yuiJsPreserveAllSemiColons) {
        this.yuiJsPreserveAllSemiColons = yuiJsPreserveAllSemiColons;
    }

    public boolean isYuiJsDisableOptimizations() {
        return this.yuiJsDisableOptimizations;
    }

    public void setYuiJsDisableOptimizations(boolean yuiJsDisableOptimizations) {
        this.yuiJsDisableOptimizations = yuiJsDisableOptimizations;
    }

    public int getYuiJsLineBreak() {
        return this.yuiJsLineBreak;
    }

    public void setYuiJsLineBreak(int yuiJsLineBreak) {
        this.yuiJsLineBreak = yuiJsLineBreak;
    }

    public int getYuiCssLineBreak() {
        return this.yuiCssLineBreak;
    }

    public void setYuiCssLineBreak(int yuiCssLineBreak) {
        this.yuiCssLineBreak = yuiCssLineBreak;
    }

    public boolean isRemoveQuotes() {
        return this.removeQuotes;
    }

    public void setRemoveQuotes(boolean removeQuotes) {
        this.removeQuotes = removeQuotes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRemoveComments() {
        return this.removeComments;
    }

    public void setRemoveComments(boolean removeComments) {
        this.removeComments = removeComments;
    }

    public boolean isRemoveJsJavaComments() {
        return this.removeJsJavaComments;
    }

    public void setRemoveJsJavaComments(boolean removeComments) {
        this.removeJsJavaComments = removeComments;
    }

    public boolean isRemoveTagLinebreaks() {
        return this.removeTagLinebreaks;
    }

    public void setRemoveTagLinebreaks(boolean removeTagLinebreaks) {
        this.removeTagLinebreaks = removeTagLinebreaks;
    }

    public boolean isRemoveMultiSpaces() {
        return this.removeMultiSpaces;
    }

    public void setRemoveMultiSpaces(boolean removeMultiSpaces) {
        this.removeMultiSpaces = removeMultiSpaces;
    }

    public boolean isRemoveIntertagSpaces() {
        return this.removeIntertagSpaces;
    }

    public void setRemoveIntertagSpaces(boolean removeIntertagSpaces) {
        this.removeIntertagSpaces = removeIntertagSpaces;
    }

    public List<Pattern> getPreservePatterns() {
        return this.preservePatterns;
    }

    public void setPreservePatterns(List<Pattern> preservePatterns) {
        this.preservePatterns = preservePatterns;
    }

    public ErrorReporter getYuiErrorReporter() {
        return this.yuiErrorReporter;
    }

    public void setYuiErrorReporter(ErrorReporter yuiErrorReporter) {
        this.yuiErrorReporter = yuiErrorReporter;
    }

    public Jader getJavaScriptCompressor() {
        return this.javaScriptCompressor;
    }

    public void setJavaScriptCompressor(Jader javaScriptCompressor) {
        this.javaScriptCompressor = javaScriptCompressor;
    }

    public Jader getCssCompressor() {
        return this.cssCompressor;
    }

    public void setCssCompressor(Jader cssCompressor) {
        this.cssCompressor = cssCompressor;
    }

    public boolean isSimpleDoctype() {
        return this.simpleDoctype;
    }

    public void setSimpleDoctype(boolean simpleDoctype) {
        this.simpleDoctype = simpleDoctype;
    }

    public boolean isRemoveScriptAttributes() {
        return this.removeScriptAttributes;
    }

    public void setRemoveScriptAttributes(boolean removeScriptAttributes) {
        this.removeScriptAttributes = removeScriptAttributes;
    }

    public boolean isRemoveStyleAttributes() {
        return this.removeStyleAttributes;
    }

    public void setRemoveStyleAttributes(boolean removeStyleAttributes) {
        this.removeStyleAttributes = removeStyleAttributes;
    }

    public boolean isRemoveLinkAttributes() {
        return this.removeLinkAttributes;
    }

    public void setRemoveLinkAttributes(boolean removeLinkAttributes) {
        this.removeLinkAttributes = removeLinkAttributes;
    }

    public boolean isRemoveFormAttributes() {
        return this.removeFormAttributes;
    }

    public void setRemoveFormAttributes(boolean removeFormAttributes) {
        this.removeFormAttributes = removeFormAttributes;
    }

    public boolean isRemoveInputAttributes() {
        return this.removeInputAttributes;
    }

    public void setRemoveInputAttributes(boolean removeInputAttributes) {
        this.removeInputAttributes = removeInputAttributes;
    }

    public boolean isSimpleBooleanAttributes() {
        return this.simpleBooleanAttributes;
    }

    public void setSimpleBooleanAttributes(boolean simpleBooleanAttributes) {
        this.simpleBooleanAttributes = simpleBooleanAttributes;
    }

    public boolean isRemoveJavaScriptProtocol() {
        return this.removeJavaScriptProtocol;
    }

    public void setRemoveJavaScriptProtocol(boolean removeJavaScriptProtocol) {
        this.removeJavaScriptProtocol = removeJavaScriptProtocol;
    }

    public boolean isRemoveHttpProtocol() {
        return this.removeHttpProtocol;
    }

    public void setRemoveHttpProtocol(boolean removeHttpProtocol) {
        this.removeHttpProtocol = removeHttpProtocol;
    }

    public boolean isRemoveHttpsProtocol() {
        return this.removeHttpsProtocol;
    }

    public void setRemoveHttpsProtocol(boolean removeHttpsProtocol) {
        this.removeHttpsProtocol = removeHttpsProtocol;
    }

    public boolean isGenerateStatistics() {
        return this.generateStatistics;
    }

    public void setGenerateStatistics(boolean generateStatistics) {
        this.generateStatistics = generateStatistics;
    }

    public HtmlJaderStatistics getStatistics() {
        return this.statistics;
    }

    public boolean isPreserveLineBreaks() {
        return this.preserveLineBreaks;
    }

    public void setPreserveLineBreaks(boolean preserveLineBreaks) {
        this.preserveLineBreaks = preserveLineBreaks;
    }

    public String getRemoveSurroundingSpaces() {
        return this.removeSurroundingSpaces;
    }

    public void setRemoveSurroundingSpaces(String tagList) {
        if (tagList != null && tagList.length() == 0) {
            tagList = null;
        }
        this.removeSurroundingSpaces = tagList;
    }

    private String escape(String html) {
        html = html.replace("\\", "\\\\");
        html = html.replace("$", "\\$");
        return html;
    }
}

