/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.core.web.jade;

import com.bes.enterprise.core.web.jade.CssJader;
import com.bes.enterprise.core.web.jade.HtmlJader;
import com.bes.enterprise.core.web.jade.Jader;
import com.bes.enterprise.core.web.jade.JavaScriptJader;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class JaderFactory {
    public static final String JAVASCRIPT = "js";
    public static final String CSS = "css";
    public static final String HTM = "htm";
    public static final String HTML = "html";
    public static final String JSP = "jsp";
    private static final JaderFactory instance = new JaderFactory();

    public static final JaderFactory getInstance() {
        return instance;
    }

    public HtmlJader newHtmlJader(boolean dynamicJadeTag) {
        HtmlJader compressor = new HtmlJader();
        compressor.setCompressCss(true);
        compressor.setCompressJavaScript(true);
        compressor.setPreserveLineBreaks(false);
        compressor.setYuiJsDisableOptimizations(true);
        compressor.setYuiJsLineBreak(-1);
        compressor.setYuiJsNoMunge(true);
        compressor.setYuiJsPreserveAllSemiColons(false);
        compressor.setRemoveTagLinebreaks(dynamicJadeTag);
        ArrayList<Pattern> preservePatterns = new ArrayList<Pattern>();
        preservePatterns.add(HtmlJader.SERVER_SIDE_INCLUDE_PATTERN);
        compressor.setPreservePatterns(preservePatterns);
        return compressor;
    }

    public CssJader newCssJader() {
        CssJader compressor = new CssJader();
        return compressor;
    }

    public JavaScriptJader newJavaScriptJader() {
        JavaScriptJader compressor = new JavaScriptJader();
        compressor.setDisableOptimizations(true);
        compressor.setLineBreak(-1);
        compressor.setNoMunge(true);
        compressor.setPreserveAllSemiColons(false);
        return compressor;
    }

    public HtmlJader newJspJader(boolean dynamicJsjava, boolean dynamicJadeTag) {
        HtmlJader compressor = new HtmlJader();
        compressor.setCompressCss(true);
        compressor.setCompressJavaScript(true);
        compressor.setYuiJsDisableOptimizations(true);
        compressor.setYuiJsLineBreak(-1);
        compressor.setYuiJsNoMunge(true);
        compressor.setYuiJsPreserveAllSemiColons(false);
        compressor.setPreserveLineBreaks(false);
        compressor.setRemoveJsJavaComments(dynamicJsjava);
        compressor.setRemoveMultiSpaces(dynamicJadeTag);
        compressor.setRemoveTagLinebreaks(dynamicJadeTag);
        ArrayList<Pattern> preservePatterns = new ArrayList<Pattern>();
        preservePatterns.add(HtmlJader.SERVER_SCRIPT_TAG_PATTERN);
        preservePatterns.add(HtmlJader.SERVER_SIDE_INCLUDE_PATTERN);
        preservePatterns.add(Pattern.compile("<jsp:.*?>", 34));
        compressor.setPreservePatterns(preservePatterns);
        return compressor;
    }

    public Jader newJader(String type, boolean dynamicJsjava, boolean dynamicJadeTag) {
        Jader compressor = null;
        if (HTML.equalsIgnoreCase(type) || HTM.equalsIgnoreCase(type)) {
            compressor = this.newHtmlJader(dynamicJadeTag);
        } else if (CSS.equalsIgnoreCase(type)) {
            compressor = this.newCssJader();
        } else if (JAVASCRIPT.equalsIgnoreCase(type)) {
            compressor = this.newJavaScriptJader();
        } else if (JSP.equalsIgnoreCase(type)) {
            compressor = this.newJspJader(dynamicJsjava, dynamicJadeTag);
        }
        return compressor;
    }
}

