/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.core.web.jade;

import com.bes.enterprise.core.web.jade.DefaultErrorReporter;
import com.bes.enterprise.core.web.jade.Jader;
import com.bes.enterprise.core.web.jade.core.CoreJavaScriptJader;
import com.bes.org.mozilla.javascript.ErrorReporter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaScriptJader
implements Jader {
    private static final Logger logger = Logger.getLogger(JavaScriptJader.class.getName());
    private boolean noMunge = false;
    private boolean preserveAllSemiColons = false;
    private boolean disableOptimizations = false;
    private int lineBreak = -1;
    private ErrorReporter errorReporter = new DefaultErrorReporter(logger);

    @Override
    public String jade(String source, boolean logEnable) throws Exception {
        StringWriter result = new StringWriter();
        ((DefaultErrorReporter)this.errorReporter).setLogEnable(logEnable);
        try {
            CoreJavaScriptJader compressor = new CoreJavaScriptJader(new StringReader(source), this.errorReporter);
            compressor.compress(result, this.lineBreak, !this.noMunge, false, this.preserveAllSemiColons, this.disableOptimizations);
        }
        catch (Exception e) {
            if (logEnable) {
                logger.log(Level.WARNING, "Error occurred while compressing JavaScript.", e);
            }
            throw e;
        }
        return result.toString();
    }

    public boolean isNoMunge() {
        return this.noMunge;
    }

    public void setNoMunge(boolean noMunge) {
        this.noMunge = noMunge;
    }

    public boolean isPreserveAllSemiColons() {
        return this.preserveAllSemiColons;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public boolean isDisableOptimizations() {
        return this.disableOptimizations;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    public int getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(int lineBreak) {
        this.lineBreak = lineBreak;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }
}

