/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.core.web.jade.core;

import com.bes.enterprise.core.web.jade.core.CoreJavaScriptJader;
import com.bes.enterprise.core.web.jade.core.JavaScriptIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class ScriptOrFnScope {
    private final int braceNesting;
    private final ScriptOrFnScope parentScope;
    private ArrayList subScopes;
    private HashMap identifiers = new HashMap();
    private final HashMap hints = new HashMap();
    private boolean markedForMunging = true;
    private int varcount = 0;

    ScriptOrFnScope(int braceNesting, ScriptOrFnScope parentScope) {
        this.braceNesting = braceNesting;
        this.parentScope = parentScope;
        this.subScopes = new ArrayList();
        if (parentScope != null) {
            parentScope.subScopes.add(this);
        }
    }

    int getBraceNesting() {
        return this.braceNesting;
    }

    ScriptOrFnScope getParentScope() {
        return this.parentScope;
    }

    JavaScriptIdentifier declareIdentifier(String symbol) {
        JavaScriptIdentifier identifier = (JavaScriptIdentifier)this.identifiers.get(symbol);
        if (identifier == null) {
            identifier = new JavaScriptIdentifier(symbol, this);
            this.identifiers.put(symbol, identifier);
        }
        return identifier;
    }

    JavaScriptIdentifier getIdentifier(String symbol) {
        return (JavaScriptIdentifier)this.identifiers.get(symbol);
    }

    void addHint(String variableName, String variableType) {
        this.hints.put(variableName, variableType);
    }

    void preventMunging() {
        if (this.parentScope != null) {
            this.markedForMunging = false;
        }
    }

    private ArrayList getUsedSymbols() {
        ArrayList<String> result = new ArrayList<String>();
        for (JavaScriptIdentifier javaScriptIdentifier : this.identifiers.entrySet()) {
            String mungedValue = javaScriptIdentifier.getMungedValue();
            if (mungedValue == null) {
                mungedValue = javaScriptIdentifier.getValue();
            }
            result.add(mungedValue);
        }
        return result;
    }

    private ArrayList getAllUsedSymbols() {
        ArrayList result = new ArrayList();
        ScriptOrFnScope scope = this;
        while (scope != null) {
            result.addAll(scope.getUsedSymbols());
            scope = scope.parentScope;
        }
        return result;
    }

    int incrementVarCount() {
        ++this.varcount;
        return this.varcount;
    }

    void munge() {
        if (!this.markedForMunging) {
            return;
        }
        int pickFromSet = 1;
        if (this.parentScope != null) {
            ArrayList freeSymbols = new ArrayList();
            freeSymbols.addAll(CoreJavaScriptJader.ones);
            freeSymbols.removeAll(this.getAllUsedSymbols());
            if (freeSymbols.size() == 0) {
                pickFromSet = 2;
                freeSymbols.addAll(CoreJavaScriptJader.twos);
                freeSymbols.removeAll(this.getAllUsedSymbols());
            }
            if (freeSymbols.size() == 0) {
                pickFromSet = 3;
                freeSymbols.addAll(CoreJavaScriptJader.threes);
                freeSymbols.removeAll(this.getAllUsedSymbols());
            }
            if (freeSymbols.size() == 0) {
                throw new IllegalStateException("The YUI Compressor ran out of symbols. Aborting...");
            }
            Iterator elements = this.identifiers.entrySet().iterator();
            while (elements.hasNext()) {
                JavaScriptIdentifier identifier;
                if (freeSymbols.size() == 0) {
                    if (++pickFromSet == 2) {
                        freeSymbols.addAll(CoreJavaScriptJader.twos);
                    } else if (pickFromSet == 3) {
                        freeSymbols.addAll(CoreJavaScriptJader.threes);
                    } else {
                        throw new IllegalStateException("The YUI Compressor ran out of symbols. Aborting...");
                    }
                    freeSymbols.removeAll(this.getAllUsedSymbols());
                }
                String mungedValue = (identifier = (JavaScriptIdentifier)((Object)elements.next())).isMarkedForMunging() ? (String)freeSymbols.remove(0) : identifier.getValue();
                identifier.setMungedValue(mungedValue);
            }
        }
        for (Object subScope : this.subScopes) {
            ScriptOrFnScope scope = (ScriptOrFnScope)subScope;
            scope.munge();
        }
    }
}

