/*
 * Decompiled with CFR 0.152.
 */
package com.bes.org.mozilla.javascript;

import com.bes.org.mozilla.javascript.BaseFunction;
import com.bes.org.mozilla.javascript.Context;
import com.bes.org.mozilla.javascript.Decompiler;
import com.bes.org.mozilla.javascript.NativeCall;
import com.bes.org.mozilla.javascript.ScriptRuntime;
import com.bes.org.mozilla.javascript.Scriptable;
import com.bes.org.mozilla.javascript.UintMap;
import com.bes.org.mozilla.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    public final void initScriptFunction(Context cx, Scriptable scope) {
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
    }

    final String decompile(int indent, int flags) {
        String encodedSource = this.getEncodedSource();
        if (encodedSource == null) {
            return super.decompile(indent, flags);
        }
        UintMap properties = new UintMap(1);
        properties.put(1, indent);
        return Decompiler.decompile(encodedSource, flags, properties);
    }

    public int getLength() {
        int paramCount = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return paramCount;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        if (activation == null) {
            return paramCount;
        }
        return activation.originalArgs.length;
    }

    public int getArity() {
        return this.getParamCount();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);

    protected abstract boolean getParamOrVarConst(int var1);
}

