/*
 * Decompiled with CFR 0.152.
 */
package com.bes.org.mozilla.javascript;

import com.bes.org.mozilla.javascript.FunctionNode;
import com.bes.org.mozilla.javascript.Kit;
import com.bes.org.mozilla.javascript.Node;
import com.bes.org.mozilla.javascript.ObjArray;
import com.bes.org.mozilla.javascript.ObjToIntMap;
import com.bes.org.mozilla.javascript.ScriptRuntime;

public class ScriptOrFnNode
extends Node {
    public static final int NO_DUPLICATE = 1;
    public static final int DUPLICATE_VAR = 0;
    public static final int DUPLICATE_PARAMETER = -1;
    public static final int DUPLICATE_CONST = -2;
    private int encodedSourceStart;
    private int encodedSourceEnd;
    private String sourceName;
    private int baseLineno = -1;
    private int endLineno = -1;
    private ObjArray functions;
    private ObjArray regexps;
    private ObjArray itsVariables = new ObjArray();
    private ObjArray itsConst = new ObjArray();
    private ObjToIntMap itsVariableNames = new ObjToIntMap(11);
    private int varStart;
    private Object compilerData;

    public ScriptOrFnNode(int nodeType) {
        super(nodeType);
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public final int getEncodedSourceStart() {
        return this.encodedSourceStart;
    }

    public final int getEncodedSourceEnd() {
        return this.encodedSourceEnd;
    }

    public final void setEncodedSourceBounds(int start, int end) {
        this.encodedSourceStart = start;
        this.encodedSourceEnd = end;
    }

    public final int getBaseLineno() {
        return this.baseLineno;
    }

    public final void setBaseLineno(int lineno) {
        if (lineno < 0 || this.baseLineno >= 0) {
            Kit.codeBug();
        }
        this.baseLineno = lineno;
    }

    public final int getEndLineno() {
        return this.endLineno;
    }

    public final void setEndLineno(int lineno) {
        if (lineno < 0 || this.endLineno >= 0) {
            Kit.codeBug();
        }
        this.endLineno = lineno;
    }

    public final int getFunctionCount() {
        if (this.functions == null) {
            return 0;
        }
        return this.functions.size();
    }

    public final FunctionNode getFunctionNode(int i) {
        return (FunctionNode)this.functions.get(i);
    }

    public final int addFunction(FunctionNode fnNode) {
        if (fnNode == null) {
            Kit.codeBug();
        }
        if (this.functions == null) {
            this.functions = new ObjArray();
        }
        this.functions.add(fnNode);
        return this.functions.size() - 1;
    }

    public final int getRegexpCount() {
        if (this.regexps == null) {
            return 0;
        }
        return this.regexps.size() / 2;
    }

    public final String getRegexpString(int index) {
        return (String)this.regexps.get(index * 2);
    }

    public final String getRegexpFlags(int index) {
        return (String)this.regexps.get(index * 2 + 1);
    }

    public final int addRegexp(String string, String flags) {
        if (string == null) {
            Kit.codeBug();
        }
        if (this.regexps == null) {
            this.regexps = new ObjArray();
        }
        this.regexps.add(string);
        this.regexps.add(flags);
        return this.regexps.size() / 2 - 1;
    }

    public final boolean hasParamOrVar(String name) {
        return this.itsVariableNames.has(name);
    }

    public final int getParamOrVarIndex(String name) {
        return this.itsVariableNames.get(name, -1);
    }

    public final String getParamOrVarName(int index) {
        return (String)this.itsVariables.get(index);
    }

    public final int getParamCount() {
        return this.varStart;
    }

    public final int getParamAndVarCount() {
        return this.itsVariables.size();
    }

    public final String[] getParamAndVarNames() {
        int N = this.itsVariables.size();
        if (N == 0) {
            return ScriptRuntime.emptyStrings;
        }
        Object[] array = new String[N];
        this.itsVariables.toArray(array);
        return array;
    }

    public final boolean[] getParamAndVarConst() {
        int N = this.itsVariables.size();
        boolean[] array = new boolean[N];
        for (int i = 0; i < N; ++i) {
            if (this.itsConst.get(i) == null) continue;
            array[i] = true;
        }
        return array;
    }

    public final void addParam(String name) {
        if (this.varStart != this.itsVariables.size()) {
            Kit.codeBug();
        }
        int index = this.varStart++;
        this.itsVariables.add(name);
        this.itsConst.add(null);
        this.itsVariableNames.put(name, index);
    }

    public final int addVar(String name) {
        int vIndex = this.itsVariableNames.get(name, -1);
        if (vIndex != -1) {
            if (vIndex >= this.varStart) {
                Object v = this.itsConst.get(vIndex);
                if (v != null) {
                    return -2;
                }
                return 0;
            }
            return -1;
        }
        int index = this.itsVariables.size();
        this.itsVariables.add(name);
        this.itsConst.add(null);
        this.itsVariableNames.put(name, index);
        return 1;
    }

    public final boolean addConst(String name) {
        int vIndex = this.itsVariableNames.get(name, -1);
        if (vIndex != -1) {
            return false;
        }
        int index = this.itsVariables.size();
        this.itsVariables.add(name);
        this.itsConst.add(name);
        this.itsVariableNames.put(name, index);
        return true;
    }

    public final void removeParamOrVar(String name) {
        int i = this.itsVariableNames.get(name, -1);
        if (i != -1) {
            this.itsVariables.remove(i);
            this.itsVariableNames.remove(name);
            ObjToIntMap.Iterator iter = this.itsVariableNames.newIterator();
            iter.start();
            while (!iter.done()) {
                int v = iter.getValue();
                if (v > i) {
                    iter.setValue(v - 1);
                }
                iter.next();
            }
        }
    }

    public final Object getCompilerData() {
        return this.compilerData;
    }

    public final void setCompilerData(Object data) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        if (this.compilerData != null) {
            throw new IllegalStateException();
        }
        this.compilerData = data;
    }
}

