/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.auth;

import com.bes.enterprise.appserver.common.auth.PasswordAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class IdentityManager {
    public static final String PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY = "com.bes.promptForIdentity";
    private static final String USER_ALIAS = "admin-user";
    private static final String PASSWORD_ALIAS = "admin-password";
    private static final String MASTER_PASSWORD_ALIAS = "master-password";
    private static final String IDENTITY_STORE_FILE_NAME = ".identity";
    private static volatile String _user = null;
    private static volatile String _password = null;
    private static volatile String _masterPassword = null;
    private static Hashtable<String, String> _htIdentity = new Hashtable();
    private static boolean bDebug = false;
    private static boolean _keystorePropertyWasSet = true;
    private static boolean _truststorePropertyWasSet = true;
    public static final String ADMIN_MASTER_PASSWORD = "BES_ADMIN_MASTERPASSWORD";
    public static final String ADMIN_PASSWORD = "BES_ADMIN_PASSWORD";
    public static final String ADMIN_USER = "BES_ADMIN_USER";

    private IdentityManager() {
    }

    public static String[] getIdentityArray() {
        ArrayList<String> ar = new ArrayList<String>();
        ar.add("BES_ADMIN_MASTERPASSWORD=" + IdentityManager.getMasterPassword());
        ar.add("BES_ADMIN_USER=" + IdentityManager.getUser());
        ar.add("BES_ADMIN_PASSWORD=" + IdentityManager.getPassword());
        for (Map.Entry<String, String> entry : _htIdentity.entrySet()) {
            ar.add(entry.getKey() + "=" + entry.getValue());
        }
        String[] identity = new String[ar.size()];
        identity = ar.toArray(identity);
        return identity;
    }

    public static void populateFromInputStreamQuietly() throws IOException {
        IdentityManager.populateFromInputStream(System.in, true);
    }

    public static void populateFromInputStream() throws IOException {
        IdentityManager.populateFromInputStream(System.in);
    }

    public static void populateFromInputStream(InputStream in) throws IOException {
        IdentityManager.populateFromInputStream(in, true);
    }

    public static void populateFromInputStream(InputStream in, boolean quiet) throws IOException {
        block14: {
            if (bDebug) {
                System.out.println("IM seeing if need to read in security properties from stdin");
            }
            if (in == null || System.getProperty(PROPMPT_FOR_IDENTITY_SYSTEM_PROPERTY) == null) {
                return;
            }
            BufferedReader br = null;
            if (bDebug) {
                System.out.println("IM attempting to read from inputstream");
            }
            br = new BufferedReader(new InputStreamReader(System.in));
            String sxLine = null;
            int cnt = 0;
            boolean ipos = false;
            if (!quiet) {
                System.out.println("Enter Admin User:");
            }
            while ((sxLine = br.readLine()) != null) {
                if (bDebug) {
                    System.out.println("IM Number read - Reading Line:" + cnt + " - " + sxLine);
                }
                switch (cnt) {
                    case 0: {
                        IdentityManager.setMasterPassword(sxLine.substring(sxLine.indexOf("=") + 1));
                        if (quiet) break;
                        System.out.println("Enter Master Password:");
                        break;
                    }
                    case 1: {
                        IdentityManager.setUser(sxLine.substring(sxLine.indexOf("=") + 1));
                        if (quiet) break;
                        System.out.println("Enter Admin User:");
                        break;
                    }
                    case 2: {
                        IdentityManager.setPassword(sxLine.substring(sxLine.indexOf("=") + 1));
                        if (!quiet) {
                            System.out.println("Enter Admin Password:");
                        }
                        break block14;
                    }
                    default: {
                        IdentityManager.putTokenizedString(sxLine);
                        if (quiet) break;
                        System.out.println("Enter Other Password Information (or ctrl-D or ctrl-Z):");
                    }
                }
                ++cnt;
            }
        }
    }

    public static void writeToOutputStream(OutputStream out) {
        if (out == null) {
            return;
        }
        PrintWriter writer = null;
        writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out)));
        if (bDebug) {
            System.out.println("Writing to OutputStream: " + IdentityManager.getFormatedContents());
        }
        writer.println(IdentityManager.getUser());
        writer.println(IdentityManager.getPassword());
        writer.println(IdentityManager.getMasterPassword());
        for (Map.Entry<String, String> entry : _htIdentity.entrySet()) {
            writer.println(entry.getKey() + "=" + entry.getValue());
        }
        writer.flush();
        writer.close();
    }

    public static String getFormatedContents() {
        StringBuffer sb = new StringBuffer("IdentityManager Data: User:" + IdentityManager.getUser());
        if (bDebug) {
            sb.append(", ");
            sb.append("Password:" + IdentityManager.getPassword() + ", ");
            sb.append("MasterPassword:" + IdentityManager.getMasterPassword() + ", ");
            for (Map.Entry<String, String> entry : _htIdentity.entrySet()) {
                sb.append(entry.getKey() + ":" + entry.getValue() + ", ");
            }
        }
        return sb.toString();
    }

    public static void setUser(String userx) {
        _user = userx;
    }

    public static String getUser() {
        return _user;
    }

    public static void setPassword(String passwordx) {
        _password = passwordx;
    }

    public static String getPassword() {
        return _password;
    }

    public static void setMasterPassword(String masterPasswordx) {
        _masterPassword = masterPasswordx;
        if (!(System.getProperty("javax.net.ssl.keyStore") == null || _keystorePropertyWasSet && System.getProperty("javax.net.ssl.keyStorePassword") != null)) {
            System.setProperty("javax.net.ssl.keyStorePassword", IdentityManager.getMasterPassword());
            _keystorePropertyWasSet = false;
        }
        if (!(System.getProperty("javax.net.ssl.trustStore") == null || _truststorePropertyWasSet && System.getProperty("javax.net.ssl.trustStorePassword") != null)) {
            System.setProperty("javax.net.ssl.trustStorePassword", IdentityManager.getMasterPassword());
            _truststorePropertyWasSet = false;
        }
    }

    public static String getMasterPassword() {
        return _masterPassword;
    }

    public static void putTokenizedString(String sxToken) {
        int ipos = sxToken.indexOf("=");
        if (ipos > 0) {
            IdentityManager.put(sxToken.substring(0, ipos), sxToken.substring(ipos + 1));
        }
    }

    public static void put(String key, String value) {
        _htIdentity.put(key, value);
    }

    public static String get(String key) {
        return _htIdentity.get(key);
    }

    public static void addToMap(HashMap map) {
        for (Map.Entry entry : map.entrySet()) {
            IdentityManager.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Map getMap() {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : _htIdentity.entrySet()) {
            hm.put(entry.getKey(), entry.getValue());
        }
        return hm;
    }

    public static void createIdentityStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        Properties aliasPasswordProps = new Properties();
        aliasPasswordProps.setProperty(USER_ALIAS, IdentityManager.getUser());
        aliasPasswordProps.setProperty(PASSWORD_ALIAS, IdentityManager.getPassword());
        aliasPasswordProps.setProperty(MASTER_PASSWORD_ALIAS, IdentityManager.getMasterPassword());
        File instanceRoot = new File(System.getProperty("com.bes.instanceRoot"), IDENTITY_STORE_FILE_NAME);
        PasswordAdapter p2 = new PasswordAdapter(instanceRoot.getAbsolutePath(), IdentityManager.getMasterPasswordPassword());
        Iterator<Object> iter = aliasPasswordProps.keySet().iterator();
        String alias = null;
        String pass = null;
        while (iter.hasNext()) {
            alias = (String)iter.next();
            pass = aliasPasswordProps.getProperty(alias);
            p2.setPasswordForAlias(alias, pass.getBytes());
        }
    }

    public static void readIdentityStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException {
        File instanceRoot = new File(System.getProperty("com.bes.instanceRoot"), IDENTITY_STORE_FILE_NAME);
        System.out.println("****** READING IDENTITY FROM ====>" + instanceRoot.getAbsolutePath());
        if (instanceRoot.exists()) {
            PasswordAdapter p2 = new PasswordAdapter(instanceRoot.getAbsolutePath(), IdentityManager.getMasterPasswordPassword());
            IdentityManager.setUser(p2.getPasswordForAlias(USER_ALIAS));
            IdentityManager.setPassword(p2.getPasswordForAlias(PASSWORD_ALIAS));
            IdentityManager.setMasterPassword(p2.getPasswordForAlias(MASTER_PASSWORD_ALIAS));
        }
    }

    public static void deleteIdentityStore() {
        File instanceRoot = new File(System.getProperty("com.bes.instanceRoot"), IDENTITY_STORE_FILE_NAME);
        instanceRoot.delete();
    }

    private static char[] getMasterPasswordPassword() {
        return MASTER_PASSWORD_ALIAS.toCharArray();
    }
}

