/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.auth;

import com.bes.enterprise.appserver.common.auth.IdentityManager;
import com.bes.enterprise.appserver.common.auth.LoginInfo;
import com.bes.enterprise.appserver.common.auth.LoginInfoStore;
import com.bes.enterprise.appserver.common.auth.LoginInfoStoreFactory;
import com.bes.enterprise.appserver.common.i18n.LocalStringsImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class LoginInfoUtils {
    private static final LocalStringsImpl strings = new LocalStringsImpl(LoginInfoUtils.class);
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static Logger logger = Logger.getLogger(LoginInfoUtils.class.getPackage().getName());

    public static void getAndSetUserPassword(String host, int port) {
        LoginInfo loginInfo = LoginInfoUtils.getLoginInfoFromIasstolpass(host, port);
        if (IdentityManager.getUser() == null) {
            IdentityManager.setUser(loginInfo.getUser());
        }
        if (IdentityManager.getPassword() == null) {
            IdentityManager.setPassword(loginInfo.getPassword());
        }
    }

    public static LoginInfo getLoginInfoFromIasstolpass(String host, int port) {
        LoginInfo login = null;
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            String hostnamefromlocal = LoginInfoUtils.getHostnameFromLocal();
            String ip = LoginInfoUtils.getIPFromLocal();
            if (host.equalsIgnoreCase(hostnamefromlocal) || host.equalsIgnoreCase(ip)) {
                host = DEFAULT_HOST_NAME;
            }
            if (store.exists(host, port)) {
                login = store.read(host, port);
            }
        }
        catch (Exception e2) {
            logger.finer(strings.get("failed.to.get.logininfo"));
        }
        return login;
    }

    protected static String getHostnameFromLocal() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e2) {
            return null;
        }
    }

    protected static String getIPFromLocal() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e2) {
            return null;
        }
    }

    public static void saveLogin(String host, int port, String user, String passwd) {
        if (host == null || "".equals(host)) {
            host = DEFAULT_HOST_NAME;
        }
        String sport = Integer.toString(port);
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            LoginInfo login = new LoginInfo(host, port, user, passwd);
            store.store(login, true);
            IdentityManager.setUser(user);
            IdentityManager.setPassword(passwd);
        }
        catch (Exception e2) {
            logger.warning(strings.get("LoginInfoNotStored", new Object[]{host, sport}));
        }
    }
}

