/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.digest;

import com.bes.enterprise.appserver.common.digest.ChallengeParseException;
import com.bes.enterprise.appserver.common.digest.DigestChallenge;
import com.bes.enterprise.appserver.common.digest.DigestChallengeResponse;
import com.bes.enterprise.appserver.common.digest.WwwAuthenticateHeader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DigestAuthentication {
    private List<DigestChallenge> challenges;
    private DigestChallengeResponse response;
    private String username;
    private String password;
    private String userDigest;
    public static final Comparator<DigestChallenge> DEFAULT_CHALLENGE_COMPARATOR = new Comparator<DigestChallenge>(){
        private final Collection<DigestChallenge.QualityOfProtection> AUTH_AUTH_INT_QOPS = EnumSet.of(DigestChallenge.QualityOfProtection.AUTH, DigestChallenge.QualityOfProtection.AUTH_INT);

        @Override
        public int compare(DigestChallenge lhs, DigestChallenge rhs) {
            int result = this.supportScore(rhs) - this.supportScore(lhs);
            if (result == 0) {
                result = this.algorithmScore(rhs) - this.algorithmScore(lhs);
            }
            if (result == 0) {
                result = this.miscScore(rhs) - this.miscScore(lhs);
            }
            return result;
        }

        private int supportScore(DigestChallenge challenge) {
            if (DigestChallengeResponse.isChallengeSupported(challenge)) {
                return 0;
            }
            return -1;
        }

        private int algorithmScore(DigestChallenge challenge) {
            if (challenge.getAlgorithm().equals("SHA-256") || challenge.getAlgorithm().equals("SHA-256-sess")) {
                return 0;
            }
            return -1;
        }

        private int miscScore(DigestChallenge challenge) {
            Set<DigestChallenge.QualityOfProtection> supportedQopTypes = challenge.getSupportedQopTypes();
            if (supportedQopTypes.containsAll(this.AUTH_AUTH_INT_QOPS)) {
                return 0;
            }
            if (supportedQopTypes.contains((Object)DigestChallenge.QualityOfProtection.AUTH)) {
                return -1;
            }
            if (supportedQopTypes.contains((Object)DigestChallenge.QualityOfProtection.UNSPECIFIED_RFC2069_COMPATIBLE)) {
                return -2;
            }
            if (supportedQopTypes.contains((Object)DigestChallenge.QualityOfProtection.AUTH_INT)) {
                return -3;
            }
            return -4;
        }
    };

    public static DigestAuthentication fromResponse(HttpURLConnection connection) throws ChallengeParseException {
        return DigestAuthentication.fromResponseHeaders(connection.getHeaderFields());
    }

    public static <T extends Iterable<String>> DigestAuthentication fromResponseHeaders(Map<String, T> headers) throws ChallengeParseException {
        return DigestAuthentication.fromChallenges(WwwAuthenticateHeader.extractChallenges(headers));
    }

    public static DigestAuthentication fromWwwAuthenticateHeaders(Iterable<String> wwwAuthenticateHeaders) throws ChallengeParseException {
        return DigestAuthentication.fromChallenges(WwwAuthenticateHeader.extractChallenges(wwwAuthenticateHeaders));
    }

    public static DigestAuthentication fromWwwAuthenticateHeader(String wwwAuthenticateHeader) throws ChallengeParseException {
        return DigestAuthentication.fromChallenges(WwwAuthenticateHeader.extractChallenges(wwwAuthenticateHeader));
    }

    public static DigestAuthentication fromChallenges(Iterable<String> challenges) throws ChallengeParseException {
        List<DigestChallenge> supportedChallenges = DigestAuthentication.createListOfMatchingSize(challenges);
        for (String challenge : challenges) {
            DigestChallenge digestChallenge;
            if (!DigestChallenge.isDigestChallenge(challenge) || !DigestChallengeResponse.isChallengeSupported(digestChallenge = DigestChallenge.parse(challenge))) continue;
            supportedChallenges.add(digestChallenge);
        }
        return new DigestAuthentication(supportedChallenges);
    }

    public static DigestAuthentication fromDigestChallenges(Iterable<? extends DigestChallenge> challenges) {
        List<DigestChallenge> supportedChallenges = DigestAuthentication.createListOfMatchingSize(challenges);
        for (DigestChallenge digestChallenge : challenges) {
            if (!DigestChallengeResponse.isChallengeSupported(digestChallenge)) continue;
            supportedChallenges.add(digestChallenge);
        }
        return new DigestAuthentication(supportedChallenges);
    }

    public static DigestAuthentication fromDigestChallenge(DigestChallenge challenge) {
        return DigestAuthentication.fromDigestChallenges(Collections.singleton(challenge));
    }

    private DigestAuthentication(List<DigestChallenge> challengesRepresentation) {
        this.challenges = challengesRepresentation;
        Collections.sort(this.challenges, DEFAULT_CHALLENGE_COMPARATOR);
    }

    public boolean canRespond() {
        return this.response != null || !this.challenges.isEmpty();
    }

    public synchronized DigestAuthentication challengeOrdering(Comparator<? super DigestChallenge> orderingComparator) {
        if (this.challenges == null) {
            throw new IllegalStateException("Cannot change challenge ordering after challenge has been chosen");
        }
        Collections.sort(this.challenges, orderingComparator);
        return this;
    }

    public synchronized boolean isEntityBodyDigestRequired() {
        return this.getChallengeResponse().isEntityBodyDigestRequired();
    }

    public synchronized DigestAuthentication username(String username) {
        if (this.response != null) {
            this.response.username(username);
        } else {
            this.username = username;
        }
        return this;
    }

    public synchronized String getUsername() {
        if (this.response != null) {
            return this.response.getUsername();
        }
        return this.username;
    }

    public synchronized DigestAuthentication password(String password) {
        if (this.response != null) {
            this.response.password(password);
        } else {
            this.password = password;
        }
        return this;
    }

    public synchronized String getPassword() {
        if (this.response != null) {
            return this.response.getPassword();
        }
        return this.password;
    }

    public synchronized DigestAuthentication userDigest(String userDigest) {
        if (this.response != null) {
            this.response.userDigest(userDigest);
        } else {
            this.userDigest = userDigest;
        }
        return this;
    }

    public synchronized String getUserDigest() {
        if (this.response != null) {
            return this.response.getUserDigest();
        }
        return this.userDigest;
    }

    public synchronized DigestChallengeResponse getChallengeResponse() {
        if (!this.canRespond()) {
            throw new IllegalStateException("None of the provided challenges is supported, no response can be generated");
        }
        if (this.response == null) {
            this.response = DigestChallengeResponse.responseTo(this.challenges.iterator().next()).username(this.username).password(this.password).userDigest(this.userDigest);
            this.challenges = null;
            this.userDigest = null;
            this.password = null;
            this.username = null;
        }
        return this.response;
    }

    public synchronized String getAuthorizationForRequest(String requestMethod, String digestUri) {
        return this.getAuthorizationForRequest(requestMethod, digestUri, new byte[0]);
    }

    public synchronized String getAuthorizationForRequest(String requestMethod, String digestUri, byte[] entityBody) {
        String result = this.getChallengeResponse().requestMethod(requestMethod).digestUri(digestUri).entityBody(entityBody).getHeaderValue();
        this.getChallengeResponse().requestMethod(null).digestUri(null).entityBody(new byte[0]).incrementNonceCount().randomizeClientNonce();
        return result;
    }

    private static List<DigestChallenge> createListOfMatchingSize(Iterable<?> iterable) {
        ArrayList<DigestChallenge> digestChallenges = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<DigestChallenge>();
        return digestChallenges;
    }

    public synchronized String toString() {
        return "DigestAuthentication{challenges=" + this.challenges + ", response=" + this.response + ", username='" + this.getUsername() + '\'' + ", password=*" + '}';
    }
}

