/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.digest;

import com.bes.enterprise.appserver.common.digest.DigestChallenge;
import com.bes.enterprise.appserver.common.digest.InsufficientInformationException;
import com.bes.enterprise.appserver.common.digest.Rfc2616AbnfParser;
import com.bes.enterprise.appserver.common.util.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public final class DigestChallengeResponse {
    public static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final int CLIENT_NONCE_BYTE_COUNT = 8;
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final byte[] clientNonceByteBuffer = new byte[8];
    private String algorithm;
    private String username;
    private String password;
    private String userDigest;
    private String clientNonce;
    private String firstRequestClientNonce;
    private String quotedNonce;
    private int nonceCount;
    private String quotedOpaque;
    private final Set<DigestChallenge.QualityOfProtection> supportedQopTypes = EnumSet.noneOf(DigestChallenge.QualityOfProtection.class);
    private String digestUri;
    private String quotedRealm;
    private String requestMethod;
    private byte[] entityBodyDigest;
    private String A1;

    public DigestChallengeResponse() {
        this.nonceCount(1).randomizeClientNonce().firstRequestClientNonce(this.getClientNonce()).entityBody(new byte[0]);
    }

    public static boolean isChallengeSupported(DigestChallenge challenge) {
        return DigestChallengeResponse.isAlgorithmSupported(challenge.getAlgorithm()) && !challenge.getSupportedQopTypes().isEmpty();
    }

    public static DigestChallengeResponse responseTo(DigestChallenge challenge) {
        return new DigestChallengeResponse().challenge(challenge);
    }

    public static boolean isAlgorithmSupported(String algorithm) {
        return algorithm == null || "MD5".equals(algorithm) || "MD5-sess".equals(algorithm) || "SHA-256".equals(algorithm) || "SHA-256-sess".equals(algorithm);
    }

    public synchronized DigestChallengeResponse algorithm(String algorithm) {
        if (!DigestChallengeResponse.isAlgorithmSupported(algorithm)) {
            throw new IllegalArgumentException("Unsupported algorithm: " + algorithm);
        }
        this.algorithm = algorithm;
        this.entityBody(new byte[0]);
        this.invalidateA1();
        return this;
    }

    public synchronized String getAlgorithm() {
        return this.algorithm;
    }

    public synchronized DigestChallengeResponse username(String username) {
        this.username = username;
        this.invalidateA1();
        return this;
    }

    public synchronized String getUsername() {
        return this.username;
    }

    public synchronized DigestChallengeResponse password(String password) {
        this.password = password;
        this.invalidateA1();
        return this;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized DigestChallengeResponse userDigest(String userDigest) {
        this.userDigest = userDigest;
        this.invalidateA1();
        return this;
    }

    public synchronized String getUserDigest() {
        return this.userDigest;
    }

    public synchronized DigestChallengeResponse clientNonce(String clientNonce) {
        this.clientNonce = clientNonce;
        if ("MD5-sess".equals(this.getAlgorithm())) {
            this.invalidateA1();
        }
        return this;
    }

    public synchronized String getClientNonce() {
        return this.clientNonce;
    }

    public synchronized DigestChallengeResponse randomizeClientNonce() {
        return this.clientNonce(DigestChallengeResponse.generateRandomNonce());
    }

    public synchronized DigestChallengeResponse firstRequestClientNonce(String firstRequestClientNonce) {
        this.firstRequestClientNonce = firstRequestClientNonce;
        if ("MD5-sess".equals(this.getAlgorithm())) {
            this.invalidateA1();
        }
        return this;
    }

    public synchronized String getFirstRequestClientNonce() {
        return this.firstRequestClientNonce;
    }

    public synchronized DigestChallengeResponse quotedNonce(String quotedNonce) {
        this.quotedNonce = quotedNonce;
        this.resetNonceCount();
        if ("MD5-sess".equals(this.getAlgorithm())) {
            this.invalidateA1();
        }
        return this;
    }

    public synchronized String getQuotedNonce() {
        return this.quotedNonce;
    }

    public synchronized DigestChallengeResponse nonce(String unquotedNonce) {
        if (unquotedNonce == null) {
            return this.quotedNonce(null);
        }
        return this.quotedNonce(Rfc2616AbnfParser.quote(unquotedNonce));
    }

    public synchronized String getNonce() {
        if (this.quotedNonce == null) {
            return null;
        }
        return Rfc2616AbnfParser.unquote(this.quotedNonce);
    }

    public synchronized DigestChallengeResponse nonceCount(int nonceCount) {
        this.nonceCount = nonceCount;
        return this;
    }

    public synchronized DigestChallengeResponse incrementNonceCount() {
        this.nonceCount(this.nonceCount + 1);
        return this;
    }

    public synchronized DigestChallengeResponse resetNonceCount() {
        this.nonceCount(1);
        return this;
    }

    public synchronized int getNonceCount() {
        return this.nonceCount;
    }

    public synchronized DigestChallengeResponse quotedOpaque(String quotedOpaque) {
        this.quotedOpaque = quotedOpaque;
        return this;
    }

    public synchronized String getQuotedOpaque() {
        return this.quotedOpaque;
    }

    public synchronized DigestChallengeResponse opaque(String unquotedOpaque) {
        if (unquotedOpaque == null) {
            return this.quotedOpaque(null);
        }
        return this.quotedOpaque(Rfc2616AbnfParser.quote(unquotedOpaque));
    }

    public synchronized String getOpaque() {
        if (this.quotedOpaque == null) {
            return null;
        }
        return Rfc2616AbnfParser.unquote(this.quotedOpaque);
    }

    public synchronized DigestChallengeResponse supportedQopTypes(Set<DigestChallenge.QualityOfProtection> supportedQopTypes) {
        if (supportedQopTypes.isEmpty()) {
            throw new IllegalArgumentException("The set of supported qop types cannot be empty");
        }
        this.supportedQopTypes.clear();
        this.supportedQopTypes.addAll(supportedQopTypes);
        return this;
    }

    public synchronized Set<DigestChallenge.QualityOfProtection> getSupportedQopTypes() {
        return Collections.unmodifiableSet(this.supportedQopTypes);
    }

    public synchronized DigestChallenge.QualityOfProtection getQop() {
        if (this.supportedQopTypes.contains((Object)DigestChallenge.QualityOfProtection.AUTH)) {
            return DigestChallenge.QualityOfProtection.AUTH;
        }
        if (this.supportedQopTypes.contains((Object)DigestChallenge.QualityOfProtection.AUTH_INT)) {
            return DigestChallenge.QualityOfProtection.AUTH_INT;
        }
        if (this.supportedQopTypes.contains((Object)DigestChallenge.QualityOfProtection.UNSPECIFIED_RFC2069_COMPATIBLE)) {
            return DigestChallenge.QualityOfProtection.UNSPECIFIED_RFC2069_COMPATIBLE;
        }
        return null;
    }

    public synchronized DigestChallengeResponse digestUri(String digestUri) {
        this.digestUri = digestUri;
        return this;
    }

    public synchronized String getDigestUri() {
        return this.digestUri;
    }

    public synchronized DigestChallengeResponse quotedRealm(String quotedRealm) {
        this.quotedRealm = quotedRealm;
        this.invalidateA1();
        return this;
    }

    public synchronized String getQuotedRealm() {
        return this.quotedRealm;
    }

    public synchronized DigestChallengeResponse realm(String unquotedRealm) {
        if (unquotedRealm == null) {
            return this.quotedRealm(null);
        }
        return this.quotedRealm(Rfc2616AbnfParser.quote(unquotedRealm));
    }

    public synchronized String getRealm() {
        if (this.quotedRealm == null) {
            return null;
        }
        return Rfc2616AbnfParser.unquote(this.quotedRealm);
    }

    public synchronized DigestChallengeResponse requestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public synchronized String getRequestMethod() {
        return this.requestMethod;
    }

    public synchronized DigestChallengeResponse entityBody(byte[] entityBody) {
        this.entityBodyDigest = this.calculateChecksum(entityBody);
        return this;
    }

    public synchronized DigestChallengeResponse entityBodyDigest(byte[] entityBodyDigest) {
        this.entityBodyDigest = Arrays.copyOf(entityBodyDigest, entityBodyDigest.length);
        return this;
    }

    public synchronized byte[] getEntityBodyDigest() {
        return Arrays.copyOf(this.entityBodyDigest, this.entityBodyDigest.length);
    }

    public synchronized boolean isEntityBodyDigestRequired() {
        return this.getQop() == DigestChallenge.QualityOfProtection.AUTH_INT;
    }

    public synchronized DigestChallengeResponse challenge(DigestChallenge challenge) {
        return this.quotedNonce(challenge.getQuotedNonce()).quotedOpaque(challenge.getQuotedOpaque()).quotedRealm(challenge.getQuotedRealm()).algorithm(challenge.getAlgorithm()).supportedQopTypes(challenge.getSupportedQopTypes());
    }

    public synchronized String getHeaderValue() {
        if (this.username == null) {
            throw new InsufficientInformationException("Mandatory username not set");
        }
        if (this.password == null) {
            throw new InsufficientInformationException("Mandatory password not set");
        }
        if (this.quotedRealm == null) {
            throw new InsufficientInformationException("Mandatory realm not set");
        }
        if (this.quotedNonce == null) {
            throw new InsufficientInformationException("Mandatory nonce not set");
        }
        if (this.digestUri == null) {
            throw new InsufficientInformationException("Mandatory digest-uri not set");
        }
        if (this.requestMethod == null) {
            throw new InsufficientInformationException("Mandatory request method not set");
        }
        if (this.getSupportedQopTypes().isEmpty() || this.getQop() == null) {
            throw new InsufficientInformationException("Mandatory supported qop types not set");
        }
        if (this.clientNonce == null && this.getQop() != DigestChallenge.QualityOfProtection.UNSPECIFIED_RFC2069_COMPATIBLE) {
            throw new InsufficientInformationException("Client nonce must be set when qop is set");
        }
        if ("MD5-sess".equals(this.getAlgorithm()) && this.getFirstRequestClientNonce() == null) {
            throw new InsufficientInformationException("First request client nonce must be set when algorithm is MD5-sess");
        }
        String response = this.calculateResponse();
        StringBuilder result = new StringBuilder();
        result.append("Digest ");
        result.append("username=");
        result.append(Rfc2616AbnfParser.quote(this.username));
        result.append(",realm=");
        result.append(this.quotedRealm);
        result.append(",nonce=");
        result.append(this.quotedNonce);
        result.append(",uri=");
        result.append(Rfc2616AbnfParser.quote(this.digestUri));
        result.append(",response=");
        result.append(response);
        if (this.getQop() != DigestChallenge.QualityOfProtection.UNSPECIFIED_RFC2069_COMPATIBLE) {
            result.append(",cnonce=");
            result.append(Rfc2616AbnfParser.quote(this.getClientNonce()));
        }
        if (this.quotedOpaque != null) {
            result.append(",opaque=");
            result.append(this.quotedOpaque);
        }
        if (this.algorithm != null) {
            result.append(",algorithm=");
            result.append(this.algorithm);
        }
        if (this.getQop() != DigestChallenge.QualityOfProtection.UNSPECIFIED_RFC2069_COMPATIBLE) {
            result.append(",qop=");
            result.append(this.getQop().getQopValue());
        }
        if (this.getQop() != DigestChallenge.QualityOfProtection.UNSPECIFIED_RFC2069_COMPATIBLE) {
            result.append(",nc=");
            result.append(String.format("%08x", this.nonceCount));
        }
        return result.toString();
    }

    private String calculateResponse() {
        MessageDigest digest = DigestChallengeResponse.createMessageDigestForAlgorithm(this.algorithm);
        DigestChallenge.QualityOfProtection qop = this.getQop();
        String a1 = this.getA1(digest);
        String a2 = this.calculateA2(qop);
        String algorithm = this.getAlgorithm();
        String secret = !StringUtils.isBlank((String)this.userDigest) && (algorithm == null || algorithm != null && !algorithm.endsWith("-sess")) ? this.userDigest : this.H(digest, a1);
        String data = "";
        switch (qop) {
            case AUTH: 
            case AUTH_INT: {
                data = this.joinWithColon(this.getNonce(), String.format("%08x", this.nonceCount), this.getClientNonce(), qop.getQopValue(), this.H(digest, a2));
                break;
            }
            case UNSPECIFIED_RFC2069_COMPATIBLE: {
                data = this.joinWithColon(this.getNonce(), this.H(digest, a2));
            }
        }
        return "\"" + this.KD(digest, secret, data) + "\"";
    }

    private static MessageDigest createMessageDigestForAlgorithm(String algorithm) {
        String androidDigestName = DigestChallengeResponse.getAndroidDigestNameForAlgorithm(algorithm);
        try {
            return MessageDigest.getInstance(androidDigestName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException("Mandatory MessageDigest not supported: " + androidDigestName);
        }
    }

    private static String getAndroidDigestNameForAlgorithm(String algorithm) {
        String androidDigestName;
        if (algorithm == null || algorithm.equals("MD5") || algorithm.equals("MD5-sess")) {
            androidDigestName = "MD5";
        } else if (algorithm.equals("SHA-256") || algorithm.equals("SHA-256-sess")) {
            androidDigestName = "SHA-256";
        } else {
            throw new IllegalArgumentException("Unsupported algorithm: " + algorithm);
        }
        return androidDigestName;
    }

    private String getA1(MessageDigest digest) {
        if (this.A1 == null) {
            this.A1 = this.calculateA1(digest);
        }
        return this.A1;
    }

    private String calculateA1(MessageDigest digest) {
        if (this.getAlgorithm() == null) {
            return this.joinWithColon(this.username, this.getRealm(), this.password);
        }
        if (this.getAlgorithm().endsWith("-sess")) {
            if (!StringUtils.isBlank((String)this.userDigest)) {
                return this.joinWithColon(this.userDigest, this.getNonce(), this.getFirstRequestClientNonce());
            }
            return this.joinWithColon(this.H(digest, this.joinWithColon(this.username, this.getRealm(), this.password)), this.getNonce(), this.getFirstRequestClientNonce());
        }
        return this.joinWithColon(this.username, this.getRealm(), this.password);
    }

    private void invalidateA1() {
        this.A1 = null;
    }

    private String calculateA2(DigestChallenge.QualityOfProtection qop) {
        if (qop == DigestChallenge.QualityOfProtection.AUTH_INT) {
            return this.joinWithColon(this.requestMethod, this.digestUri, DigestChallengeResponse.encodeHexString(this.entityBodyDigest));
        }
        return this.joinWithColon(this.requestMethod, this.digestUri);
    }

    private String joinWithColon(String ... parts) {
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (result.length() > 0) {
                result.append(':');
            }
            result.append(part);
        }
        return result.toString();
    }

    private String H(MessageDigest digest, String string) {
        return DigestChallengeResponse.encodeHexString(this.calculateChecksum(digest, string.getBytes()));
    }

    private byte[] calculateChecksum(MessageDigest digest, byte[] data) {
        digest.reset();
        digest.update(data);
        return digest.digest();
    }

    private byte[] calculateChecksum(byte[] data) {
        return this.calculateChecksum(DigestChallengeResponse.createMessageDigestForAlgorithm(this.algorithm), data);
    }

    private String KD(MessageDigest digest, String secret, String data) {
        return this.H(digest, secret + ":" + data);
    }

    private static String encodeHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder(bytes.length * 2);
        for (byte b2 : bytes) {
            result.append(Integer.toHexString((b2 & 0xF0) >> 4));
            result.append(Integer.toHexString(b2 & 0xF));
        }
        return result.toString();
    }

    private static synchronized String generateRandomNonce() {
        RANDOM.nextBytes(clientNonceByteBuffer);
        return DigestChallengeResponse.encodeHexString(clientNonceByteBuffer);
    }

    public synchronized String toString() {
        return "DigestChallengeResponse{algorithm=" + this.algorithm + ", realm=" + this.quotedRealm + ", supportedQopTypes=" + this.supportedQopTypes + ", nonce=" + this.quotedNonce + ", nonceCount=" + this.nonceCount + ", clientNonce=" + this.clientNonce + ", firstRequestClientNonce=" + this.firstRequestClientNonce + ", opaque=" + this.quotedOpaque + ", username=" + this.username + ", password=*, requestMethod=" + this.requestMethod + ", digestUri=" + this.digestUri + ", entityBodyDigest=" + Arrays.toString(this.entityBodyDigest) + '}';
    }
}

