/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.resource;

import com.bes.enterprise.appserver.common.resource.SharableResourceManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExternalResoureManager {
    private static final Logger log = Logger.getLogger(ExternalResoureManager.class.getName());
    private static ExternalResoureManager extResoureMgr = new ExternalResoureManager();
    private static ThreadLocal<ArrayListStack> threadLocalContext = new ThreadLocal();
    public static final String CLOSE_VAL = "close";
    public static final String ISCLOSE_VAL = "isClosed";
    private boolean detectExternalResource = Boolean.valueOf(System.getProperty("com.bes.resource.leakDetect", "false"));
    private boolean ejbDetected = Boolean.valueOf(System.getProperty("com.bes.resource.ejb.leakDetect", "false"));
    private static final String LEAK_DETECT = "com.bes.resource.leakDetect";
    private static final String LEAK_EJB_DETECT = "com.bes.resource.ejb.leakDetect";

    public static ExternalResoureManager getInstance() {
        return extResoureMgr;
    }

    private ExternalResoureManager() {
    }

    public void ejbPreInvoke() {
        if (!this.detectExternalResource) {
            return;
        }
        if (!this.ejbDetected) {
            return;
        }
        ResourceContext resourceContext = new ResourceContext();
        ArrayListStack resourceContextStack = threadLocalContext.get();
        if (resourceContextStack == null) {
            resourceContextStack = new ArrayListStack();
            threadLocalContext.set(resourceContextStack);
        }
        resourceContextStack.push(resourceContext);
    }

    public void ejbPostInvoke() {
        if (!this.detectExternalResource) {
            return;
        }
        if (!this.ejbDetected) {
            return;
        }
        ArrayListStack resourceContextStack = threadLocalContext.get();
        ResourceContext resourceContext = (ResourceContext)resourceContextStack.pop();
        if (resourceContext != null) {
            resourceContext.cleanupResources();
        }
    }

    public void webPreInvoke() {
        ResourceContext resourceContext;
        SharableResourceManager.getInstance().webPreInvoke();
        if (!this.detectExternalResource) {
            return;
        }
        ArrayListStack resourceContextStack = threadLocalContext.get();
        if (resourceContextStack == null) {
            resourceContextStack = new ArrayListStack();
            threadLocalContext.set(resourceContextStack);
        }
        if ((resourceContext = (ResourceContext)resourceContextStack.peek()) == null) {
            resourceContext = new ResourceContext();
            resourceContextStack.push(resourceContext);
        }
    }

    public void webPostInvoke() {
        SharableResourceManager.getInstance().webPostInvoke();
        if (!this.detectExternalResource) {
            return;
        }
        ArrayListStack resourceContextStack = threadLocalContext.get();
        ResourceContext resourceContext = (ResourceContext)resourceContextStack.pop();
        if (resourceContext != null) {
            resourceContext.cleanupResources();
        }
    }

    public void addExternalResoure(Object extResource) {
        ResourceContext resourceContext;
        if (!this.detectExternalResource) {
            return;
        }
        ArrayListStack beanContextStack = threadLocalContext.get();
        if (beanContextStack != null && (resourceContext = (ResourceContext)beanContextStack.peek()) != null) {
            resourceContext.addResource(extResource);
        }
    }

    class ArrayListStack
    extends ArrayList {
        public ArrayListStack(int size) {
            super(size);
        }

        public ArrayListStack() {
        }

        public void push(Object obj) {
            super.add(obj);
        }

        public Object pop() {
            int sz = super.size();
            return sz > 0 ? super.remove(sz - 1) : null;
        }

        public boolean empty() {
            return super.size() == 0;
        }

        public Object peek() {
            int sz = this.size();
            return sz > 0 ? super.get(sz - 1) : null;
        }
    }

    class ResourceContext {
        private List<Object> resources = new ArrayList<Object>(1);

        ResourceContext() {
        }

        public void addResource(Object extResoure) {
            this.resources.add(extResoure);
        }

        public void cleanupResources() {
            Iterator<Object> it = this.resources.iterator();
            while (it.hasNext()) {
                Object resourceWrapper = it.next();
                it.remove();
                this.closeResource(resourceWrapper);
            }
        }

        private void closeResource(Object extResource) {
            block8: {
                boolean closeInvoked = false;
                try {
                    Method isClosedMethod = extResource.getClass().getMethod(ExternalResoureManager.ISCLOSE_VAL, new Class[0]);
                    if (isClosedMethod != null) {
                        closeInvoked = (Boolean)isClosedMethod.invoke(extResource, new Object[0]);
                    }
                }
                catch (Throwable isClosedMethod) {
                    // empty catch block
                }
                if (!closeInvoked) {
                    try {
                        Method closeMethod = extResource.getClass().getMethod(ExternalResoureManager.CLOSE_VAL, new Class[0]);
                        if (closeMethod != null) {
                            closeMethod.setAccessible(true);
                            closeMethod.invoke(extResource, new Object[0]);
                            if (log.isLoggable(Level.WARNING)) {
                                log.warning("Resource (" + extResource.hashCode() + ") does not released normally, and released it again successfully!");
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (!log.isLoggable(Level.WARNING)) break block8;
                        log.warning("Resource (" + extResource.hashCode() + ") does not released normally, and failed to release it again!");
                    }
                }
            }
        }
    }
}

