/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.security;

import com.bes.enterprise.appserver.common.process.ExecException;
import com.bes.enterprise.appserver.common.process.ProcessExecutor;
import com.bes.enterprise.appserver.common.process.ProcessUtils;
import com.bes.enterprise.appserver.common.util.NetUtils;
import com.bes.enterprise.appserver.common.util.OSUtils;
import com.bes.enterprise.appserver.common.util.RepositoryException;
import com.bes.enterprise.appserver.common.util.SanitizeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

public class KeystoreManager {
    private static final String KEYTOOL_CMD;
    private static final String KEYTOOL_EXE_NAME;
    private static String CERTIFICATE_DN_PREFIX;
    private static String CERTIFICATE_DN_SUFFIX;
    public static final String CERTIFICATE_ALIAS = "bes";
    public static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SKID_EXTENSION_SYSTEM_PROPERTY = "-J-Dsun.security.internal.keytool.skid";
    private File securityDir;
    private File keyStoreFile;
    private File trustStoreFile;

    public KeystoreManager(String serverDir) {
        this.securityDir = new File(serverDir, "conf/security");
        this.keyStoreFile = new File(this.securityDir, "keystore.jks");
        this.trustStoreFile = new File(this.securityDir, "cacerts.jks");
    }

    public void createSSLCertificateDatabase(String masterPassword) {
        this.createKeyStore(masterPassword);
        this.createTrustStore(masterPassword);
    }

    public void createSSLCertificateDatabase() {
        this.createKeyStore(DEFAULT_MASTER_PASSWORD);
        this.createTrustStore(DEFAULT_MASTER_PASSWORD);
    }

    public File getSecurityDir() {
        return this.securityDir;
    }

    public File getKeyStore() {
        return this.keyStoreFile;
    }

    public File getTrustStore() {
        return this.trustStoreFile;
    }

    protected void createKeyStore(String masterPassword) {
        File keystore = this.getKeyStore();
        if (keystore.exists()) {
            keystore.delete();
        }
        String CertDN = KeystoreManager.getCertDN();
        System.out.println("The type of security store is: JKS.");
        System.out.println("Distinguished Name of the self-signed X.509 Server Certificate is:");
        System.out.println("[" + CertDN + "]");
        this.addSelfSignedCertToKeyStore(keystore, CERTIFICATE_ALIAS, masterPassword, CertDN);
        try {
            this.chmod("755", keystore);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addSelfSignedCertToKeyStore(File keystore, String alias, String masterPassword, String dn) {
        String[] keytoolCmd = new String[]{"-genkey", "-keyalg", "RSA", "-sigalg", "SHA1WithRSA", "-keysize", "2048", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-dname", dn, "-validity", "3650", "-keypass", masterPassword, "-storepass", masterPassword, "-storetype", "JKS", SKID_EXTENSION_SYSTEM_PROPERTY};
        KeytoolExecutor p2 = new KeytoolExecutor(keytoolCmd, 300L);
        try {
            p2.execute("keystoreNotCreated", keystore);
        }
        catch (RepositoryException e2) {
            e2.printStackTrace();
        }
    }

    protected void createTrustStore(String masterPassword) {
        File truststore = this.getTrustStore();
        this.changeKeystorePassword(DEFAULT_MASTER_PASSWORD, masterPassword, truststore);
        this.copyCert(CERTIFICATE_ALIAS, masterPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCert(String alias, String masterPassword) {
        File keystore = this.getKeyStore();
        File truststore = this.getTrustStore();
        File certFile = null;
        String[] input = new String[]{masterPassword};
        String[] keytoolCmd = null;
        KeytoolExecutor p2 = null;
        try {
            certFile = new File(this.getSecurityDir(), alias + ".cer");
            keytoolCmd = new String[]{"-export", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-storetype", "JKS", "-file", certFile.getAbsolutePath()};
            p2 = new KeytoolExecutor(keytoolCmd, 300L, input);
            try {
                p2.execute("trustStoreNotCreated", truststore);
            }
            catch (RepositoryException e2) {
                e2.printStackTrace();
            }
            keytoolCmd = new String[]{"-import", "-noprompt", "-keystore", truststore.getAbsolutePath(), "-alias", alias, "-storetype", "JKS", "-file", certFile.getAbsolutePath()};
            p2 = new KeytoolExecutor(keytoolCmd, 300L, input);
            try {
                p2.execute("trustStoreNotCreated", truststore);
            }
            catch (RepositoryException e3) {
                try {
                    keytoolCmd = new String[]{"-delete", "-noprompt", "-keystore", truststore.getAbsolutePath(), "-alias", alias, "-storetype", "JKS"};
                    p2 = new KeytoolExecutor(keytoolCmd, 300L, input);
                    p2.execute("trustStoreNotCreated", truststore);
                    keytoolCmd = new String[]{"-import", "-noprompt", "-keystore", truststore.getAbsolutePath(), "-alias", alias, "-storetype", "JKS", "-file", certFile.getAbsolutePath()};
                    p2 = new KeytoolExecutor(keytoolCmd, 300L, input);
                    p2.execute("trustStoreNotCreated", truststore);
                }
                catch (RepositoryException re) {
                    re.printStackTrace();
                }
            }
        }
        finally {
            boolean isCertFileDeleted;
            if (certFile != null && !(isCertFileDeleted = certFile.delete())) {
                System.out.println("errorDeletingTempCertFile:" + certFile.getAbsolutePath());
            }
        }
    }

    protected void changeKeystorePassword(String oldPassword, String newPassword, File keystore) {
        if (!oldPassword.equals(newPassword)) {
            String[] keytoolCmd = new String[]{"-storepasswd", "-keystore", keystore.getAbsolutePath()};
            KeytoolExecutor p2 = new KeytoolExecutor(keytoolCmd, 300L, new String[]{oldPassword, newPassword, newPassword});
            try {
                p2.execute("keyStorePasswordNotChanged", keystore);
            }
            catch (RepositoryException e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void changeBESAliasPassword(String storePassword, String oldKeyPassword, String newKeyPassword) throws RepositoryException {
        block25: {
            if (!storePassword.equals(oldKeyPassword) && !oldKeyPassword.equals(newKeyPassword)) {
                FileInputStream is;
                ArrayList<String> aliases;
                File keystore;
                block23: {
                    keystore = this.getKeyStore();
                    String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
                    if (keyStoreType == null) {
                        keyStoreType = KeyStore.getDefaultType();
                    }
                    aliases = new ArrayList<String>();
                    is = null;
                    KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                    is = new FileInputStream(keystore);
                    keyStore.load(is, storePassword.toCharArray());
                    Enumeration<String> all = keyStore.aliases();
                    while (all.hasMoreElements()) {
                        aliases.add(all.nextElement());
                    }
                    if (is == null) break block23;
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                String[] keytoolCmd = new String[]{"-list", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
                KeytoolExecutor p2 = new KeytoolExecutor(keytoolCmd, 300L, new String[]{storePassword});
                try {
                    p2.execute("besKeyPasswordNotChanged", keystore);
                }
                catch (RepositoryException ex) {
                    return;
                }
                for (String alias : aliases) {
                    keytoolCmd = new String[]{"-keypasswd", "-keystore", keystore.getAbsolutePath(), "-alias", alias};
                    p2 = new KeytoolExecutor(keytoolCmd, 300L, new String[]{storePassword, oldKeyPassword, newKeyPassword, newKeyPassword});
                    p2.execute("besKeyPasswordNotChanged", keystore);
                }
                break block25;
                catch (Exception e2) {
                    block24: {
                        aliases.add(CERTIFICATE_ALIAS);
                        if (is == null) break block24;
                        try {
                            is.close();
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    keytoolCmd = new String[]{"-list", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
                    p3 = new KeytoolExecutor(keytoolCmd, 300L, new String[]{storePassword});
                    try {
                        p3.execute("besKeyPasswordNotChanged", keystore);
                    }
                    catch (RepositoryException ex3) {
                        return;
                    }
                    for (String alias : aliases) {
                        keytoolCmd = new String[]{"-keypasswd", "-keystore", keystore.getAbsolutePath(), "-alias", alias};
                        p3 = new KeytoolExecutor(keytoolCmd, 300L, new String[]{storePassword, oldKeyPassword, newKeyPassword, newKeyPassword});
                        p3.execute("besKeyPasswordNotChanged", keystore);
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ex4) {
                                ex4.printStackTrace();
                            }
                        }
                        String[] keytoolCmd2 = new String[]{"-list", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
                        KeytoolExecutor p32 = new KeytoolExecutor(keytoolCmd2, 300L, new String[]{storePassword});
                        try {
                            p32.execute("besKeyPasswordNotChanged", keystore);
                        }
                        catch (RepositoryException ex5) {
                            return;
                        }
                        for (String alias : aliases) {
                            keytoolCmd2 = new String[]{"-keypasswd", "-keystore", keystore.getAbsolutePath(), "-alias", alias};
                            p32 = new KeytoolExecutor(keytoolCmd2, 300L, new String[]{storePassword, oldKeyPassword, newKeyPassword, newKeyPassword});
                            p32.execute("besKeyPasswordNotChanged", keystore);
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    protected void changeSSLCertificateDatabasePassword(String oldPassword, String newPassword) {
        File keystore = this.getKeyStore();
        File truststore = this.getTrustStore();
        if (keystore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, keystore);
            try {
                this.changeBESAliasPassword(newPassword, oldPassword, newPassword);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (truststore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, truststore);
        }
    }

    protected void chmod(String args, File file) throws IOException {
        if (OSUtils.isUNIX()) {
            if (args == null || file == null) {
                throw new IOException("Args is null!");
            }
            if (!file.exists()) {
                throw new IOException("File:" + file + " is found!");
            }
            String[] argsString = args.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("/bin/chmod");
            cmdList.addAll(Arrays.asList(argsString));
            cmdList.add(file.getAbsolutePath());
            new ProcessBuilder(cmdList).start();
        }
    }

    public static String getCertDN() {
        String cn;
        try {
            cn = NetUtils.getCanonicalHostName();
        }
        catch (UnknownHostException e2) {
            cn = "localhost";
        }
        String x509DistinguishedName = CERTIFICATE_DN_PREFIX + cn + CERTIFICATE_DN_SUFFIX;
        return x509DistinguishedName;
    }

    static {
        KEYTOOL_EXE_NAME = OSUtils.isWindows() ? "keytool.exe" : "keytool";
        CERTIFICATE_DN_PREFIX = "CN=";
        CERTIFICATE_DN_SUFFIX = ",OU=BES Application Server,O=bessystem,L=Haidian,ST=Beijing,C=CN";
        String nonFinalKeyTool = KEYTOOL_EXE_NAME;
        String javaroot = System.getenv("JAVA_HOME");
        File k2 = new File(new File(javaroot, "bin"), KEYTOOL_EXE_NAME);
        if (k2.canExecute()) {
            nonFinalKeyTool = SanitizeFile.sanitize((String)k2.getPath());
        } else {
            k2 = ProcessUtils.getExe(KEYTOOL_EXE_NAME);
            if (k2 != null && k2.canExecute()) {
                nonFinalKeyTool = k2.getPath();
            }
        }
        KEYTOOL_CMD = nonFinalKeyTool;
    }

    protected static class KeytoolExecutor
    extends ProcessExecutor {
        public KeytoolExecutor(String[] args, long timeoutSeconds) {
            super(args, timeoutSeconds);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        public KeytoolExecutor(String[] args, long timeoutSeconds, String[] inputLines) {
            super(args, timeoutSeconds, inputLines);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        @Override
        protected String getExceptionMessage() {
            return this.getLatestOutput(this.mOutFile) + " " + this.getFileBuffer(this.mErrFile);
        }

        private void addKeytoolCommand() {
            if (!this.mCmdStrings[0].equals(KEYTOOL_CMD)) {
                String[] newArgs = new String[this.mCmdStrings.length + 1];
                newArgs[0] = KEYTOOL_CMD;
                System.arraycopy(this.mCmdStrings, 0, newArgs, 1, this.mCmdStrings.length);
                this.mCmdStrings = newArgs;
            }
        }

        public void execute(String keystoreErrorMsg, File keystoreName) throws RepositoryException {
            try {
                super.execute();
                if (this.getProcessExitValue() != 0) {
                    throw new RepositoryException(keystoreErrorMsg + this.getLastExecutionError() + " " + this.getLastExecutionOutput());
                }
            }
            catch (ExecException ex) {
                throw new RepositoryException(keystoreErrorMsg + this.getLastExecutionError() + " " + this.getLastExecutionOutput(), ex);
            }
        }
    }
}

