/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.user.parse;

import com.bes.enterprise.appserver.common.user.UsersVo;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class UsersXmlParser {
    private static Logger logger = Logger.getLogger(UsersXmlParser.class.getName());
    private JAXBContext jaxbContext;
    private static UsersXmlParser parser = new UsersXmlParser();
    private static File userFile = new File(System.getProperty("com.bes.instanceRoot") + File.separator + "conf" + File.separator + "security" + File.separator + "user.xml");

    private UsersXmlParser() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{UsersVo.class});
        }
        catch (JAXBException e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
        }
    }

    public static UsersXmlParser getInstance() {
        return parser;
    }

    public static File getUserXmlFile() {
        return userFile;
    }

    private Marshaller makeMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.fragment", (Object)false);
        return marshaller;
    }

    private Unmarshaller makeUnmarshaller() throws JAXBException {
        return this.jaxbContext.createUnmarshaller();
    }

    public UsersVo unmarshal() throws JAXBException {
        UsersVo usersVo = null;
        usersVo = (UsersVo)this.makeUnmarshaller().unmarshal(userFile);
        return usersVo;
    }

    public void marshal(UsersVo usersVo) throws JAXBException {
        this.makeMarshaller().marshal((Object)usersVo, userFile);
    }
}

