/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.auth.AuthenticationException;
import com.bes.enterprise.appserver.common.auth.BadRequestException;
import com.bes.enterprise.appserver.common.digest.ChallengeParseException;
import com.bes.enterprise.appserver.common.digest.DigestAuthentication;
import com.bes.enterprise.appserver.common.i18n.LocalStringsImpl;
import com.bes.enterprise.appserver.common.ssl.BasicHostnameVerifier;
import com.bes.enterprise.appserver.common.ssl.BasicTrustManager;
import com.bes.enterprise.appserver.common.util.SecurityUtil;
import com.bes.enterprise.appserver.common.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public abstract class BaseHttpConnection {
    protected static final LocalStringsImpl strings = new LocalStringsImpl(BaseHttpConnection.class);
    public static final String AUTHORIZATION_KEY = "Authorization";
    public static final String AUTHORIZATION_DIGEST_TYPE = "Digest ";
    public static final String INITIATOR_HEADER_NAME = "BES-Digest-Initiator";
    public static final String HASH_HEADER_NAME = "BES-Digest-Hash";
    private String host;
    private int port;
    private String remoteUri;
    private Map<String, String> requestParameters = new HashMap<String, String>();
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private boolean secure;
    private String user;
    private String password;
    private String authToken = null;
    private DigestAuthentication digestAuthentication = null;
    private int readTimeout = 300000;
    private int connectTimeout = 120000;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRemoteUri() {
        return this.remoteUri;
    }

    public void setRemoteUri(String remoteUri) {
        this.remoteUri = remoteUri;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void addRequestParameter(String parameterKey, String parameterValue) {
        this.requestParameters.put(parameterKey, parameterValue);
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.requestHeaders.put(headerName, headerValue);
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object send() throws IOException, KeyManagementException, NoSuchAlgorithmException, Exception {
        HttpURLConnection conn = null;
        URL connURL = this.toURL(this.host, this.port, this.secure, this.remoteUri, this.requestParameters);
        try {
            String redirection;
            conn = this.openConnection(connURL);
            this.sendData(conn);
            boolean digestAuth = this.checkDigestAuthenticate(conn);
            if (digestAuth) {
                conn = this.tryDigestAuthenticate(conn, connURL);
            }
            if ((redirection = this.checkResponse(conn)) != null) {
                conn.disconnect();
                connURL = new URL(redirection);
                conn = this.openConnection(connURL);
                this.sendData(conn);
                redirection = this.checkResponse(conn);
                if (redirection != null) {
                    throw new IOException("Redirect too many times, could not redirect to " + redirection + ".");
                }
            }
            Object object = this.handleResponse(conn);
            return object;
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                }
                catch (Exception exception) {}
                conn.disconnect();
            }
        }
    }

    private boolean checkDigestAuthenticate(HttpURLConnection conn) throws IOException {
        if (conn == null) {
            return false;
        }
        if (conn.getResponseCode() != 401) {
            return false;
        }
        return this.canDigestAuthenticate(conn);
    }

    private HttpURLConnection tryDigestAuthenticate(HttpURLConnection oldConn, URL connURL) throws NoSuchAlgorithmException, IOException, KeyManagementException {
        oldConn.disconnect();
        String realRequestMethod = oldConn.getRequestMethod();
        HttpURLConnection newConn = this.openConnection(connURL, realRequestMethod);
        this.sendData(newConn);
        return newConn;
    }

    private boolean canDigestAuthenticate(HttpURLConnection conn) {
        try {
            DigestAuthentication authenticate = DigestAuthentication.fromResponse(conn);
            String up = this.user == null ? "" : this.user;
            String pp = this.password == null ? "" : this.password;
            String hashHeaderValue = conn.getHeaderField(HASH_HEADER_NAME);
            authenticate.username(up).password(pp).userDigest(hashHeaderValue);
            if (!authenticate.canRespond()) {
                return false;
            }
            this.digestAuthentication = authenticate;
        }
        catch (ChallengeParseException e2) {
            return false;
        }
        return true;
    }

    private String getDigestAuthString(HttpURLConnection conn, String realRequestMethod) {
        if (this.digestAuthentication == null) {
            return AUTHORIZATION_DIGEST_TYPE;
        }
        String requestMethod = realRequestMethod != null ? realRequestMethod : conn.getRequestMethod();
        String requestPath = conn.getURL().getFile();
        String authorization = this.digestAuthentication.getAuthorizationForRequest(requestMethod, requestPath);
        return authorization;
    }

    protected abstract void sendData(HttpURLConnection var1) throws IOException, KeyManagementException, NoSuchAlgorithmException;

    protected abstract Object handleResponse(HttpURLConnection var1) throws IOException, KeyManagementException, NoSuchAlgorithmException, Exception;

    private URL toURL(String host, int port, boolean secure, String remoteUri, Map<String, String> requestParameters) throws MalformedURLException {
        StringBuilder uriStringBuilder = new StringBuilder();
        if (secure) {
            uriStringBuilder.append("https://");
        } else {
            uriStringBuilder.append("http://");
        }
        if (!(!host.contains(":") || host.contains("[") && host.contains("]"))) {
            uriStringBuilder.append('[').append(host).append(']');
        } else {
            uriStringBuilder.append(host);
        }
        uriStringBuilder.append(':').append(port).append('/').append(remoteUri);
        if (!requestParameters.isEmpty()) {
            uriStringBuilder.append('?');
            for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
                uriStringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
                uriStringBuilder.append('&');
            }
            uriStringBuilder.deleteCharAt(uriStringBuilder.length() - 1);
        }
        URL connURL = new URL(uriStringBuilder.toString());
        return connURL;
    }

    protected HttpURLConnection openConnection(URL connURL) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        return this.openConnection(connURL, null);
    }

    private HttpURLConnection openConnection(URL connURL, String realRequestMethod) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        try {
            HttpURLConnection conn = (HttpURLConnection)connURL.openConnection();
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection sslConn = (HttpsURLConnection)conn;
                SSLContext sSLContext = this.getSSLContext();
                SSLSocketFactory sslSocketFactory = sSLContext.getSocketFactory();
                sslConn.setSSLSocketFactory(sslSocketFactory);
                sslConn.setHostnameVerifier((HostnameVerifier)new BasicHostnameVerifier());
            }
            if (this.connectTimeout > 0) {
                conn.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout > 0) {
                conn.setReadTimeout(this.readTimeout);
            }
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            this.configConnectionProperty(conn);
            String user = this.getUser();
            if (!StringUtils.isBlank((String)user)) {
                conn.setRequestProperty(INITIATOR_HEADER_NAME, user);
            }
            if (this.digestAuthentication != null) {
                conn.setRequestProperty(AUTHORIZATION_KEY, this.getDigestAuthString(conn, realRequestMethod));
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();
            return conn;
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        catch (KeyManagementException kmEx) {
            throw kmEx;
        }
        catch (NoSuchAlgorithmException algEx) {
            throw algEx;
        }
    }

    protected abstract void configConnectionProperty(HttpURLConnection var1) throws IOException;

    protected String checkResponse(HttpURLConnection conn) throws IOException, AuthenticationException, BadRequestException {
        int _statusCode = 500;
        _statusCode = conn.getResponseCode();
        if (_statusCode == 302) {
            String location = conn.getHeaderField("Location");
            return location;
        }
        if (_statusCode == 401) {
            throw new AuthenticationException(strings.get("InvalidCredentials", new Object[]{this.user}));
        }
        if (_statusCode == 400) {
            throw new BadRequestException(strings.get("bad.request"));
        }
        InputStream is = null;
        if (_statusCode != 200) {
            StringBuffer errBuffer = new StringBuffer();
            try {
                int ch;
                is = conn.getInputStream();
                if (is != null) {
                    while ((ch = is.read()) >= 0) {
                        errBuffer.append((char)ch);
                    }
                    is.close();
                }
                if ((is = conn.getErrorStream()) != null) {
                    while ((ch = is.read()) >= 0) {
                        errBuffer.append((char)ch);
                    }
                }
            }
            catch (FileNotFoundException e2) {
                throw new IOException("Cannot connect to " + conn.toString() + ".", e2);
            }
            catch (IOException e3) {
                if (is == null) {
                    throw new IOException("Response code " + _statusCode + ".", e3);
                }
                throw new IOException("Response code " + _statusCode + ": " + errBuffer, e3);
            }
            if (is != null) {
                is.close();
            }
            throw new IOException("Response code " + _statusCode + ": " + errBuffer.toString());
        }
        return null;
    }

    protected SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new BasicTrustManager()}, new SecureRandom());
        return sslContext;
    }

    private String getBase64Encoded(String clearString) {
        return SecurityUtil.base64Encode(clearString);
    }
}

