/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.BaseHttpConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;

public class DownloadFileConnection
extends BaseHttpConnection {
    private String downloadDir;
    private String downloadFileName;
    private String encode;

    public String getDownloadDir() {
        return this.downloadDir;
    }

    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public String getDownloadFileName() {
        return this.downloadFileName;
    }

    public void setDownloadFileName(String downloadFileName) {
        this.downloadFileName = downloadFileName;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    @Override
    public Object send() throws IOException, KeyManagementException, NoSuchAlgorithmException, Exception {
        this.validate();
        return super.send();
    }

    protected void validate() throws IOException {
        File checkedDir = new File(this.downloadDir);
        if (!checkedDir.exists()) {
            throw new IOException("The download directory " + this.downloadDir + " does not exist!");
        }
        if (!checkedDir.isDirectory()) {
            throw new IOException("Should specify a directory for store download file, the file " + this.downloadDir + " does not exist!");
        }
    }

    @Override
    protected void sendData(HttpURLConnection conn) throws IOException, KeyManagementException, NoSuchAlgorithmException {
    }

    @Override
    protected Object handleResponse(HttpURLConnection conn) throws IOException, KeyManagementException, NoSuchAlgorithmException, Exception {
        File downloadFile = this.getDownloadFile(conn);
        byte[] data = new byte[8192];
        int length = -1;
        FileOutputStream fOut = null;
        try {
            InputStream in = conn.getInputStream();
            fOut = new FileOutputStream(downloadFile);
            while ((length = in.read(data)) != -1) {
                fOut.write(data, 0, length);
            }
            fOut.flush();
            File file = downloadFile;
            return file;
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File getDownloadFile(HttpURLConnection conn) throws IOException {
        String contentDisposition = conn.getHeaderField("Content-Disposition");
        if (this.encode != null) {
            contentDisposition = URLDecoder.decode(contentDisposition, this.encode);
        }
        if (contentDisposition == null || "".equals(contentDisposition)) {
            String errMsg = String.format("Missing Content-Disposition header, could not download file from url %s!", conn.getURL().toString());
            throw new IOException(errMsg);
        }
        int fileNameIndex = contentDisposition.indexOf("filename=");
        if (fileNameIndex == -1) {
            String errMsg = String.format("Missing filename atrribute in Content-Disposition header, could not download file from url %s!", conn.getURL().toString());
            throw new IOException(errMsg);
        }
        if (this.downloadFileName != null) {
            File downloadFile = new File(this.downloadDir, this.downloadFileName);
            return downloadFile;
        }
        String fileName = contentDisposition.substring(fileNameIndex + "filename=".length());
        File downloadFile = new File(this.downloadDir, fileName);
        return downloadFile;
    }

    @Override
    protected void configConnectionProperty(HttpURLConnection conn) throws IOException {
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-type", "application/octet-stream");
        conn.setRequestProperty("connection", "close");
    }
}

