/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.util.ArrayList;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static Throwable[] getCauses(Throwable start) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        boolean haveNonException = false;
        Throwable t2 = start;
        while (t2 != null) {
            Throwable temp;
            list.add(t2);
            if (!(t2 instanceof Exception)) {
                haveNonException = true;
            }
            if ((temp = t2.getCause()) == null) break;
            t2 = temp;
        }
        Throwable[] results = haveNonException ? new Throwable[list.size()] : new Exception[list.size()];
        list.toArray(results);
        return results;
    }

    public static Throwable getRootCause(Throwable e2) {
        Throwable[] causes = ExceptionUtil.getCauses(e2);
        return causes[causes.length - 1];
    }

    public static String getStackTrace(Throwable t2) {
        StringBuffer buf = new StringBuffer();
        StackTraceElement[] elems = t2.getStackTrace();
        for (int i2 = 0; i2 < elems.length; ++i2) {
            buf.append(elems[i2]);
            buf.append("\n");
        }
        return buf.toString();
    }

    public static boolean hasConnectExceptionCause(Throwable throwable) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (cause instanceof ConnectException || cause instanceof NoRouteToHostException) {
                return true;
            }
            if (cause == cause.getCause()) break;
        }
        return false;
    }
}

