/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileMergeUtil {
    public static void mergeZipFiles(File srcFile, File destFile) throws IOException {
        String fileName = destFile.getName();
        String suffix = "";
        if (fileName.contains(".")) {
            int suffixIndex = fileName.lastIndexOf(".");
            suffix = fileName.substring(suffixIndex);
            fileName = fileName.substring(0, suffixIndex);
        }
        File tempFile = File.createTempFile(fileName, suffix, destFile.getParentFile());
        try {
            FileMergeUtil.mergeToTempFile(srcFile, destFile, tempFile);
        }
        catch (IOException ex) {
            boolean deleted = FileMergeUtil.deleteFileWithRetry(tempFile);
            if (!deleted) {
                FileMergeUtil.deleteOnExit(srcFile);
            }
            throw ex;
        }
        try {
            FileMergeUtil.renameTempFile(tempFile, destFile);
        }
        catch (IOException ex) {
            boolean deleted = FileMergeUtil.deleteFileWithRetry(tempFile);
            if (!deleted) {
                FileMergeUtil.deleteOnExit(srcFile);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeToTempFile(File srcFile, File destFile, File tempFile) throws IOException {
        ZipFile srcZip = null;
        ZipFile destZip = null;
        try (ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(tempFile));){
            srcZip = new ZipFile(srcFile);
            destZip = new ZipFile(destFile);
            Enumeration<? extends ZipEntry> srcEnums = srcZip.entries();
            while (srcEnums.hasMoreElements()) {
                ZipEntry entry = srcEnums.nextElement();
                String entryName = entry.getName();
                ZipEntry copyEntry = new ZipEntry(entryName);
                zOut.putNextEntry(copyEntry);
                InputStream in = srcZip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileMergeUtil.copyStream(in, zOut);
                    zOut.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            Enumeration<? extends ZipEntry> destEnums = destZip.entries();
            while (destEnums.hasMoreElements()) {
                ZipEntry entry = destEnums.nextElement();
                String entryName = entry.getName();
                ZipEntry srcEntry = srcZip.getEntry(entryName);
                if (srcEntry != null) continue;
                ZipEntry copyEntry = new ZipEntry(entryName);
                zOut.putNextEntry(copyEntry);
                InputStream in = destZip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileMergeUtil.copyStream(in, zOut);
                    zOut.closeEntry();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (Throwable throwable) {
            FileMergeUtil.closeQuietly(srcZip);
            FileMergeUtil.closeQuietly(destZip);
            throw throwable;
        }
        FileMergeUtil.closeQuietly(srcZip);
        FileMergeUtil.closeQuietly(destZip);
    }

    public static void renameTempFile(File mergeFile, File deployFile) throws IOException {
        File bakFile = new File(deployFile.getParentFile(), deployFile.getName() + ".bak");
        if (deployFile.exists() && bakFile.exists() && !bakFile.delete()) {
            String msg = String.format("Could not delete previous backup file at %s.", bakFile.getAbsolutePath());
            throw new IOException(msg);
        }
        boolean rename = FileMergeUtil.renameWithRetry(deployFile, bakFile);
        if (!rename) {
            String msg = String.format("Could not rename %s to backup file %s.", deployFile.getAbsolutePath(), bakFile.getAbsolutePath());
            throw new IOException(msg);
        }
        boolean success = FileMergeUtil.renameWithRetry(mergeFile, deployFile);
        if (!success) {
            String msg = String.format("Could not rename %s to %s", mergeFile.getAbsolutePath(), deployFile.getAbsolutePath());
            if (!FileMergeUtil.renameWithRetry(bakFile, deployFile)) {
                msg = msg + "\n" + String.format("Could not rename backup file to %s.", deployFile.getAbsolutePath());
            }
            throw new IOException(msg);
        }
        FileMergeUtil.deleteFileWithRetry(bakFile);
    }

    public static void mergeZipFilesByFileSystem(File srcFile, File destFile) throws IOException {
        FileMergeUtil.mergeZipFilesByFileSystem(srcFile, destFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeZipFilesByFileSystem(File srcFile, File destFile, String encoding) throws IOException {
        Set<String> overrideEntries = FileMergeUtil.getOverrideEntries(srcFile, destFile);
        HashMap<String, String> env = new HashMap<String, String>();
        if (encoding != null && !"".equals(encoding.trim())) {
            env.put("encoding", encoding);
        }
        URI uri = URI.create("jar:" + destFile.toURI());
        ZipFile srcZip = null;
        FileSystem fs = null;
        try {
            fs = FileSystems.newFileSystem(uri, env);
            srcZip = new ZipFile(srcFile);
            Enumeration<? extends ZipEntry> enums = srcZip.entries();
            while (enums.hasMoreElements()) {
                ZipEntry entry = enums.nextElement();
                String entryName = entry.getName();
                Path destPath = fs.getPath(entryName, new String[0]);
                if (entry.isDirectory() || entryName.endsWith("/")) {
                    if (overrideEntries.contains(entryName)) continue;
                    Files.createDirectory(destPath, new FileAttribute[0]);
                    continue;
                }
                InputStream in = null;
                try {
                    in = srcZip.getInputStream(entry);
                    if (!overrideEntries.contains(entryName)) {
                        OutputStream out = Files.newOutputStream(destPath, StandardOpenOption.CREATE);
                        Throwable throwable = null;
                        try {
                            FileMergeUtil.copyStream(in, out);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            out.close();
                            continue;
                        }
                    }
                    Files.copy(in, destPath, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    FileMergeUtil.closeQuietly(in);
                }
            }
        }
        catch (Throwable throwable) {
            FileMergeUtil.closeQuietly(srcZip);
            if (fs != null) {
                fs.close();
            }
            throw throwable;
        }
        FileMergeUtil.closeQuietly(srcZip);
        if (fs != null) {
            fs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getOverrideEntries(File srcFile, File destFile) throws IOException {
        HashSet<String> overrideEntries = new HashSet<String>();
        ZipFile srcZip = null;
        ZipFile destZip = null;
        try {
            srcZip = new ZipFile(srcFile);
            destZip = new ZipFile(destFile);
            Enumeration<? extends ZipEntry> enums = srcZip.entries();
            while (enums.hasMoreElements()) {
                ZipEntry entry = enums.nextElement();
                String entryName = entry.getName();
                ZipEntry destEntry = destZip.getEntry(entryName);
                if (destEntry == null) continue;
                overrideEntries.add(entryName);
            }
        }
        catch (Throwable throwable) {
            FileMergeUtil.closeQuietly(srcZip);
            FileMergeUtil.closeQuietly(destZip);
            throw throwable;
        }
        FileMergeUtil.closeQuietly(srcZip);
        FileMergeUtil.closeQuietly(destZip);
        return overrideEntries;
    }

    public static void mergeZipFileToDir(File srcFile, File destDir) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile);
            FileMergeUtil.mergeZipFileToDir(zipFile, destDir);
        }
        catch (Throwable throwable) {
            FileMergeUtil.closeQuietly(zipFile);
            throw throwable;
        }
        FileMergeUtil.closeQuietly(zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeZipFileToDir(ZipFile zipFile, File destDir) throws IOException {
        if (!destDir.exists()) {
            return;
        }
        Enumeration<? extends ZipEntry> enums = zipFile.entries();
        while (enums.hasMoreElements()) {
            ZipEntry entry = enums.nextElement();
            String entryName = entry.getName();
            if (entry.isDirectory() || entryName.endsWith("/")) {
                File copyDir;
                if (entryName.endsWith("/")) {
                    entryName = entryName.substring(0, entryName.length() - 1);
                }
                if ((copyDir = new File(destDir, entryName)).exists()) continue;
                copyDir.mkdirs();
                continue;
            }
            FileOutputStream out = null;
            InputStream in = null;
            try {
                File copyFile = new File(destDir, entryName);
                out = new FileOutputStream(copyFile);
                in = zipFile.getInputStream(entry);
                FileMergeUtil.copyStream(in, out);
            }
            catch (Throwable throwable) {
                FileMergeUtil.closeQuietly(in);
                FileMergeUtil.closeQuietly(out);
                throw throwable;
            }
            FileMergeUtil.closeQuietly(in);
            FileMergeUtil.closeQuietly(out);
        }
    }

    private static boolean renameWithRetry(File fromFile, File toFile) {
        boolean success = fromFile.renameTo(toFile);
        if (!success) {
            success = fromFile.renameTo(toFile);
        }
        return success;
    }

    private static boolean deleteFileWithRetry(File file) {
        if (!file.exists()) {
            return true;
        }
        boolean deleted = file.delete();
        if (!deleted) {
            if (!file.exists()) {
                return true;
            }
            deleted = file.delete();
        }
        return deleted;
    }

    private static void deleteOnExit(File file) {
        if (!file.exists()) {
            return;
        }
        file.deleteOnExit();
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] b2 = new byte[4096];
        int len = 0;
        while ((len = in.read(b2)) != -1) {
            out.write(b2, 0, len);
        }
        out.flush();
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

