/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import java.util.StringTokenizer;

public class HostAndPort {
    private final String host;
    private final int port;
    private final boolean secure;
    private boolean enabled = false;

    public HostAndPort(String host, int port, boolean secure) {
        this.host = host;
        this.port = port;
        this.secure = secure;
    }

    public HostAndPort(HostAndPort rhs) {
        this(rhs.host, rhs.port, rhs.secure);
    }

    public HostAndPort(String host, int port) {
        this(host, port, false);
    }

    public HostAndPort(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ":", false);
        this.host = tokenizer.nextToken();
        String portString = tokenizer.nextToken();
        this.port = Integer.parseInt(portString);
        this.secure = false;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port == 0) {
            return this.secure ? 8443 : 8080;
        }
        return this.port;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostAndPort other = (HostAndPort)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

