/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.PlainTextTypeConvert;

public class PlainTextTypeConvertHelper {
    public static boolean isPlainTextType(Class typeClass) {
        if (String.class == typeClass) {
            return true;
        }
        if (Boolean.class == typeClass || Boolean.TYPE == typeClass) {
            return true;
        }
        if (Integer.class == typeClass || Integer.TYPE == typeClass) {
            return true;
        }
        if (Long.class == typeClass || Long.TYPE == typeClass) {
            return true;
        }
        if (Double.class == typeClass || Double.TYPE == typeClass) {
            return true;
        }
        if (Float.class == typeClass || Float.TYPE == typeClass) {
            return true;
        }
        if (Short.class == typeClass || Short.TYPE == typeClass) {
            return true;
        }
        return Byte.class == typeClass || Byte.TYPE == typeClass;
    }

    public static PlainTextTypeConvert getPlainTextTypeConvert(Class typeClass) {
        if (String.class == typeClass) {
            return new PlainTextTypeConvert.StringConvert();
        }
        if (Boolean.class == typeClass || Boolean.TYPE == typeClass) {
            return new PlainTextTypeConvert.BooleanConvert();
        }
        if (Integer.class == typeClass || Integer.TYPE == typeClass) {
            return new PlainTextTypeConvert.IntegerConvert();
        }
        if (Long.class == typeClass || Long.TYPE == typeClass) {
            return new PlainTextTypeConvert.LongConvert();
        }
        if (Double.class == typeClass || Double.TYPE == typeClass) {
            return new PlainTextTypeConvert.DoubleConvert();
        }
        if (Float.class == typeClass || Float.TYPE == typeClass) {
            return new PlainTextTypeConvert.FloatConvert();
        }
        if (Short.class == typeClass || Short.TYPE == typeClass) {
            return new PlainTextTypeConvert.ShortConvert();
        }
        if (Byte.class == typeClass || Byte.TYPE == typeClass) {
            return new PlainTextTypeConvert.ByteConvert();
        }
        throw new IllegalArgumentException("Type " + typeClass.getName() + " is not a primitive type or string type.");
    }
}

