/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import com.bes.enterprise.appserver.common.util.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SPIUtils {
    private static Logger logger = null;
    private static final String SPI_RESOURCE_PREFIX = "META-INF/services/";

    public static String findServiceProvider(String serviceName, ClassLoader classLoader) {
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(SPI_RESOURCE_PREFIX + serviceName);
        }
        catch (IOException e2) {
            if (SPIUtils.getLogger().isLoggable(Level.WARNING)) {
                SPIUtils.getLogger().log(Level.WARNING, "Failed to get Service Provider(SPI) resource " + serviceName, e2);
            }
            return null;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String provider = SPIUtils.getServiceProviderName(url);
            if (!StringUtils.ok((String)provider)) continue;
            return provider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getServiceProviderName(URL url) {
        BufferedReader br;
        InputStream is;
        block8: {
            String string;
            block7: {
                is = null;
                br = null;
                try {
                    is = url.openStream();
                    br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        String providerName;
                        int endIndex = line.indexOf(35);
                        if (endIndex < 0) {
                            endIndex = line.length();
                        }
                        if ((providerName = line.substring(0, endIndex).trim()).isEmpty()) continue;
                        string = providerName;
                        SPIUtils.closeIfNotNull(br);
                        break block7;
                    }
                    SPIUtils.closeIfNotNull(br);
                    break block8;
                }
                catch (Exception e2) {
                    if (!SPIUtils.getLogger().isLoggable(Level.WARNING)) return null;
                    SPIUtils.getLogger().log(Level.WARNING, "Failed to read Service Provider(SPI) names from " + url.toString(), e2);
                    return null;
                }
            }
            SPIUtils.closeIfNotNull(is);
            return string;
        }
        SPIUtils.closeIfNotNull(is);
        return null;
        finally {
            SPIUtils.closeIfNotNull(br);
            SPIUtils.closeIfNotNull(is);
        }
    }

    private static void closeIfNotNull(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("javax.enterprise.system.util");
        }
        return logger;
    }
}

