/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionUtil {
    private static String product_name = "BES Application Server";
    private static String abbrev_product_name = "bes";
    private static String full_version = "9.5.5";
    private static String short_version = "9.5";
    private static String build_id = "user-private";
    private static String version_prefix = "";
    private static String version_suffix = "";
    private static String copyright_duration = "2017";
    private static final String patch_file_path = "license/version";
    private static final String PATCH_TIME = "PatchTime";
    private static final String PATCH_VERSION = "PatchVersion";

    public static String getVersion() {
        if (product_name == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(product_name);
        if (VersionUtil.ok(version_prefix)) {
            sb.append(' ').append(version_prefix);
        }
        if (full_version != null) {
            sb.append(' ').append(full_version);
        }
        if (VersionUtil.ok(version_suffix)) {
            sb.append(' ').append(version_suffix);
        }
        return sb.toString();
    }

    public static String getShortVersion() {
        if (product_name == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(product_name);
        if (VersionUtil.ok(version_prefix)) {
            sb.append(' ').append(version_prefix);
        }
        if (short_version != null) {
            sb.append(' ').append(short_version);
        }
        if (VersionUtil.ok(version_suffix)) {
            sb.append(' ').append(version_suffix);
        }
        return sb.toString();
    }

    public static String getFullVersion() {
        String version = VersionUtil.getVersion() + " (build " + build_id + ")";
        String patch = VersionUtil.getPatchVersion();
        if (!"".equals(patch.trim())) {
            version = version + "\r\n" + patch;
        }
        return version;
    }

    public static String getAbbreviatedVersion() {
        return abbrev_product_name;
    }

    public static String getBuildVersion() {
        return build_id;
    }

    public static String getVersionPrefix() {
        return version_prefix;
    }

    public static String getVersionSuffix() {
        return version_suffix;
    }

    public static String getProductName() {
        return product_name;
    }

    public static String getAbbrevProductName() {
        return abbrev_product_name;
    }

    public static String getCopyrightDuration() {
        return copyright_duration;
    }

    private static boolean ok(String s2) {
        return s2 != null && s2.length() > 0;
    }

    public static String getPatchVersion() {
        Properties patchProperties = VersionUtil.getPatchFromFile();
        if (null != patchProperties.get(PATCH_TIME) && null != patchProperties.get(PATCH_VERSION)) {
            return "(patch time " + patchProperties.get(PATCH_TIME) + ") (patch build " + patchProperties.get(PATCH_VERSION) + ")";
        }
        return "";
    }

    public static String getBriefPatchVersion() {
        Properties patchProperties = VersionUtil.getPatchFromFile();
        if (null != patchProperties.get(PATCH_VERSION)) {
            return patchProperties.getProperty(PATCH_VERSION);
        }
        return full_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPatchFromFile() {
        Properties prop = new Properties();
        String patchFilePath = System.getProperty("com.bes.patchRoot");
        if (patchFilePath == null || patchFilePath.trim().isEmpty()) {
            patchFilePath = System.getProperty("com.bes.installRoot");
        }
        File patchFile = new File(patchFilePath, patch_file_path);
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(patchFile));
            prop.load(in);
        }
        catch (Exception e2) {
            Properties properties = new Properties();
            return properties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }
}

