/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.startup;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class ASURLClassLoader
extends URLClassLoader {
    private static final boolean cacheEnable = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.common.loader.cache.enable", "true"));
    private SoftReference<ConcurrentHashMap<String, Object>> softReference;
    private static final Log log = LogFactory.getLog(ASURLClassLoader.class);

    public ASURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public ASURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public ASURLClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result;
        if (cacheEnable && (result = this.loadClassFromCache(name)) == null) {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                this.cache(name, ex);
                throw ex;
            }
        }
        return super.findClass(name);
    }

    @Override
    public URL findResource(String name) {
        String nameToPath = name;
        if (name != null && name.startsWith("/")) {
            nameToPath = name.substring(1);
        }
        if (cacheEnable) {
            String result = this.findResourceFromCache(nameToPath);
            if (result != null) {
                return null;
            }
            URL url = super.findResource(nameToPath);
            if (url == null) {
                this.cache(nameToPath, nameToPath);
            }
            return url;
        }
        return super.findResource(nameToPath);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        String nameToPath = name;
        if (name != null && name.startsWith("/")) {
            nameToPath = name.substring(1);
        }
        if (cacheEnable) {
            String result = this.findResourceFromCache(nameToPath);
            if (result != null) {
                return Collections.emptyEnumeration();
            }
            Enumeration<URL> enumeration = super.findResources(nameToPath);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                this.cache(nameToPath, nameToPath);
            }
            return enumeration;
        }
        return super.findResources(nameToPath);
    }

    private String findResourceFromCache(String name) {
        Object cacheObj = this.getCacheResource(name);
        if (cacheObj != null) {
            if (log.isDebugEnabled()) {
                log.debug("  Returning class from cache");
            }
            if (cacheObj instanceof String && name.equals(cacheObj)) {
                return name;
            }
        }
        return null;
    }

    private Class<?> loadClassFromCache(String name) throws ClassNotFoundException {
        Object cacheObj = this.getCacheResource(name);
        if (cacheObj != null) {
            if (log.isDebugEnabled()) {
                log.debug("  Returning class from cache");
            }
            if (cacheObj instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cacheObj;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(String key, Object obj) {
        ConcurrentHashMap<String, Object> cache = this.getCacheMap();
        if (cache == null) {
            ASURLClassLoader aSURLClassLoader = this;
            synchronized (aSURLClassLoader) {
                cache = this.getCacheMap();
                if (cache == null) {
                    cache = new ConcurrentHashMap<String, Object>();
                    this.softReference = new SoftReference(cache);
                }
            }
        }
        cache.put(key, obj);
    }

    protected ConcurrentHashMap getCacheMap() {
        if (this.softReference != null) {
            return this.softReference.get();
        }
        return null;
    }

    private Object getCacheResource(String key) {
        ConcurrentHashMap cache = this.getCacheMap();
        if (cache != null) {
            return cache.get(key);
        }
        return null;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

