/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.appserver.startup;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DelegatingClassLoader
extends URLClassLoader {
    private static final Log log;
    private static volatile DelegatingClassLoader instance;
    private final List<ClassLoader> classLoaderChain = new LinkedList<ClassLoader>();
    private final Map<String, ClassLoader> rarModuleClassLoaders = new HashMap<String, ClassLoader>();
    private final ClassLoader parent;

    private DelegatingClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DelegatingClassLoader getInstance(ClassLoader parent) {
        if (instance != null) return instance;
        Class<DelegatingClassLoader> clazz = DelegatingClassLoader.class;
        synchronized (DelegatingClassLoader.class) {
            if (instance != null) return instance;
            instance = new DelegatingClassLoader(parent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static DelegatingClassLoader getInstance() {
        return instance;
    }

    public Map<String, ClassLoader> getRarModuleClassLoaders() {
        return this.rarModuleClassLoaders;
    }

    public synchronized void addResourceAdapter(ClassLoader loader, String rarName) {
        this.classLoaderChain.add(loader);
        this.rarModuleClassLoaders.put(rarName, loader);
    }

    public synchronized void removeResourceAdapter(String rarName) {
        ClassLoader classLoaderToRemove = this.rarModuleClassLoaders.get(rarName);
        if (classLoaderToRemove != null) {
            this.classLoaderChain.remove(classLoaderToRemove);
            this.rarModuleClassLoaders.remove(rarName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("loadClass(" + name + ", " + resolve + ")");
        }
        Class<?> clz = null;
        if (this.parent != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("  Delegating to parent classloader: " + this.parent);
                }
                if ((clz = this.parent.loadClass(name)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clz);
                    }
                    return clz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        LinkedList<ClassLoader> tmpChain = new LinkedList<ClassLoader>();
        if (this.classLoaderChain.size() > 0) {
            DelegatingClassLoader delegatingClassLoader = this;
            synchronized (delegatingClassLoader) {
                tmpChain.addAll(this.classLoaderChain);
            }
        }
        for (ClassLoader classLoader : tmpChain) {
            URLClassLoader ccl = (URLClassLoader)classLoader;
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to rar classloader: " + classLoader);
            }
            try {
                clz = ccl.loadClass(name);
                if (clz == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("  Loading class from rar classloader!");
                }
                if (resolve) {
                    this.resolveClass(clz);
                }
                return clz;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("    --> Returning ClassNotFoundException");
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL findResource(String name) {
        String nameToPath = name;
        if (name != null && name.startsWith("/")) {
            nameToPath = name.substring(1);
        }
        return super.findResource(nameToPath);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        String nameToPath = name;
        if (name != null && name.startsWith("/")) {
            nameToPath = name.substring(1);
        }
        return super.findResources(nameToPath);
    }

    static {
        ClassLoader.registerAsParallelCapable();
        log = LogFactory.getLog(DelegatingClassLoader.class);
    }
}

