/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.base.disruptor;

import com.bes.enterprise.base.disruptor.AlertException;
import com.bes.enterprise.base.disruptor.Sequence;
import com.bes.enterprise.base.disruptor.SequenceBarrier;
import com.bes.enterprise.base.disruptor.WaitStrategy;
import com.bes.enterprise.base.disruptor.util.ThreadHints;

public final class BlockingWaitStrategy
implements WaitStrategy {
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        if (cursorSequence.get() < sequence) {
            Object object = this.mutex;
            synchronized (object) {
                while (cursorSequence.get() < sequence) {
                    barrier.checkAlert();
                    this.mutex.wait();
                }
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
            ThreadHints.onSpinWait();
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWhenBlocking() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public String toString() {
        return "BlockingWaitStrategy{mutex=" + this.mutex + '}';
    }
}

