/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.base.disruptor;

import com.bes.enterprise.base.disruptor.AlertException;
import com.bes.enterprise.base.disruptor.Sequence;
import com.bes.enterprise.base.disruptor.SequenceBarrier;
import com.bes.enterprise.base.disruptor.WaitStrategy;
import com.bes.enterprise.base.disruptor.util.ThreadHints;

public final class BusySpinWaitStrategy
implements WaitStrategy {
    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
            ThreadHints.onSpinWait();
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }
}

