/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.base.disruptor;

import com.bes.enterprise.base.disruptor.AlertException;
import com.bes.enterprise.base.disruptor.Sequence;
import com.bes.enterprise.base.disruptor.SequenceBarrier;
import com.bes.enterprise.base.disruptor.TimeoutException;
import com.bes.enterprise.base.disruptor.WaitStrategy;
import com.bes.enterprise.base.disruptor.util.Util;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class LiteTimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final Object mutex = new Object();
    private final AtomicBoolean signalNeeded = new AtomicBoolean(false);
    private final long timeoutInNanos;

    public LiteTimeoutBlockingWaitStrategy(long timeout, TimeUnit units) {
        this.timeoutInNanos = units.toNanos(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException, TimeoutException {
        long availableSequence;
        long nanos = this.timeoutInNanos;
        if (cursorSequence.get() < sequence) {
            Object object = this.mutex;
            synchronized (object) {
                while (cursorSequence.get() < sequence) {
                    this.signalNeeded.getAndSet(true);
                    barrier.checkAlert();
                    if ((nanos = Util.awaitNanos(this.mutex, nanos)) > 0L) continue;
                    throw TimeoutException.INSTANCE;
                }
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWhenBlocking() {
        if (this.signalNeeded.getAndSet(false)) {
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
        }
    }

    public String toString() {
        return "LiteTimeoutBlockingWaitStrategy{mutex=" + this.mutex + ", signalNeeded=" + this.signalNeeded + ", timeoutInNanos=" + this.timeoutInNanos + '}';
    }
}

