/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.base.disruptor;

import com.bes.enterprise.base.disruptor.AlertException;
import com.bes.enterprise.base.disruptor.Sequence;
import com.bes.enterprise.base.disruptor.SequenceBarrier;
import com.bes.enterprise.base.disruptor.TimeoutException;
import com.bes.enterprise.base.disruptor.WaitStrategy;
import com.bes.enterprise.base.disruptor.util.Util;
import java.util.concurrent.TimeUnit;

public class TimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final Object mutex = new Object();
    private final long timeoutInNanos;

    public TimeoutBlockingWaitStrategy(long timeout, TimeUnit units) {
        this.timeoutInNanos = units.toNanos(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException, TimeoutException {
        long availableSequence;
        long timeoutNanos = this.timeoutInNanos;
        if (cursorSequence.get() < sequence) {
            Object object = this.mutex;
            synchronized (object) {
                while (cursorSequence.get() < sequence) {
                    barrier.checkAlert();
                    if ((timeoutNanos = Util.awaitNanos(this.mutex, timeoutNanos)) > 0L) continue;
                    throw TimeoutException.INSTANCE;
                }
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWhenBlocking() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public String toString() {
        return "TimeoutBlockingWaitStrategy{mutex=" + this.mutex + ", timeoutInNanos=" + this.timeoutInNanos + '}';
    }
}

