/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.base.disruptor.dsl;

import com.bes.enterprise.base.disruptor.BatchEventProcessor;
import com.bes.enterprise.base.disruptor.EventFactory;
import com.bes.enterprise.base.disruptor.EventHandler;
import com.bes.enterprise.base.disruptor.EventProcessor;
import com.bes.enterprise.base.disruptor.EventTranslator;
import com.bes.enterprise.base.disruptor.EventTranslatorOneArg;
import com.bes.enterprise.base.disruptor.EventTranslatorThreeArg;
import com.bes.enterprise.base.disruptor.EventTranslatorTwoArg;
import com.bes.enterprise.base.disruptor.ExceptionHandler;
import com.bes.enterprise.base.disruptor.RingBuffer;
import com.bes.enterprise.base.disruptor.Sequence;
import com.bes.enterprise.base.disruptor.SequenceBarrier;
import com.bes.enterprise.base.disruptor.TimeoutException;
import com.bes.enterprise.base.disruptor.WaitStrategy;
import com.bes.enterprise.base.disruptor.WorkHandler;
import com.bes.enterprise.base.disruptor.WorkerPool;
import com.bes.enterprise.base.disruptor.dsl.BasicExecutor;
import com.bes.enterprise.base.disruptor.dsl.ConsumerInfo;
import com.bes.enterprise.base.disruptor.dsl.ConsumerRepository;
import com.bes.enterprise.base.disruptor.dsl.EventHandlerGroup;
import com.bes.enterprise.base.disruptor.dsl.EventProcessorFactory;
import com.bes.enterprise.base.disruptor.dsl.ExceptionHandlerSetting;
import com.bes.enterprise.base.disruptor.dsl.ExceptionHandlerWrapper;
import com.bes.enterprise.base.disruptor.dsl.ProducerType;
import com.bes.enterprise.base.disruptor.util.Util;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Disruptor<T> {
    private final RingBuffer<T> ringBuffer;
    private final Executor executor;
    private final ConsumerRepository<T> consumerRepository = new ConsumerRepository();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ExceptionHandler<? super T> exceptionHandler = new ExceptionHandlerWrapper<T>();

    @Deprecated
    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, Executor executor) {
        this(RingBuffer.createMultiProducer(eventFactory, ringBufferSize), executor);
    }

    @Deprecated
    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, Executor executor, ProducerType producerType, WaitStrategy waitStrategy) {
        this(RingBuffer.create(producerType, eventFactory, ringBufferSize, waitStrategy), executor);
    }

    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, ThreadFactory threadFactory) {
        this(RingBuffer.createMultiProducer(eventFactory, ringBufferSize), new BasicExecutor(threadFactory));
    }

    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, ThreadFactory threadFactory, ProducerType producerType, WaitStrategy waitStrategy) {
        this(RingBuffer.create(producerType, eventFactory, ringBufferSize, waitStrategy), new BasicExecutor(threadFactory));
    }

    private Disruptor(RingBuffer<T> ringBuffer, Executor executor) {
        this.ringBuffer = ringBuffer;
        this.executor = executor;
    }

    @SafeVarargs
    public final EventHandlerGroup<T> handleEventsWith(EventHandler<? super T> ... handlers) {
        return this.createEventProcessors(new Sequence[0], handlers);
    }

    @SafeVarargs
    public final EventHandlerGroup<T> handleEventsWith(EventProcessorFactory<T> ... eventProcessorFactories) {
        Sequence[] barrierSequences = new Sequence[]{};
        return this.createEventProcessors(barrierSequences, eventProcessorFactories);
    }

    public EventHandlerGroup<T> handleEventsWith(EventProcessor ... processors) {
        for (EventProcessor processor : processors) {
            this.consumerRepository.add(processor);
        }
        Sequence[] sequences = new Sequence[processors.length];
        for (int i2 = 0; i2 < processors.length; ++i2) {
            sequences[i2] = processors[i2].getSequence();
        }
        this.ringBuffer.addGatingSequences(sequences);
        return new EventHandlerGroup<T>(this, this.consumerRepository, Util.getSequencesFor(processors));
    }

    @SafeVarargs
    public final EventHandlerGroup<T> handleEventsWithWorkerPool(WorkHandler<T> ... workHandlers) {
        return this.createWorkerPool(new Sequence[0], workHandlers);
    }

    public void handleExceptionsWith(ExceptionHandler<? super T> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setDefaultExceptionHandler(ExceptionHandler<? super T> exceptionHandler) {
        this.checkNotStarted();
        if (!(this.exceptionHandler instanceof ExceptionHandlerWrapper)) {
            throw new IllegalStateException("setDefaultExceptionHandler can not be used after handleExceptionsWith");
        }
        ((ExceptionHandlerWrapper)this.exceptionHandler).switchTo(exceptionHandler);
    }

    public ExceptionHandlerSetting<T> handleExceptionsFor(EventHandler<T> eventHandler) {
        return new ExceptionHandlerSetting<T>(eventHandler, this.consumerRepository);
    }

    @SafeVarargs
    public final EventHandlerGroup<T> after(EventHandler<T> ... handlers) {
        Sequence[] sequences = new Sequence[handlers.length];
        int handlersLength = handlers.length;
        for (int i2 = 0; i2 < handlersLength; ++i2) {
            sequences[i2] = this.consumerRepository.getSequenceFor(handlers[i2]);
        }
        return new EventHandlerGroup<T>(this, this.consumerRepository, sequences);
    }

    public EventHandlerGroup<T> after(EventProcessor ... processors) {
        for (EventProcessor processor : processors) {
            this.consumerRepository.add(processor);
        }
        return new EventHandlerGroup<T>(this, this.consumerRepository, Util.getSequencesFor(processors));
    }

    public void publishEvent(EventTranslator<T> eventTranslator) {
        this.ringBuffer.publishEvent(eventTranslator);
    }

    public <A> void publishEvent(EventTranslatorOneArg<T, A> eventTranslator, A arg) {
        this.ringBuffer.publishEvent(eventTranslator, arg);
    }

    public <A> void publishEvents(EventTranslatorOneArg<T, A> eventTranslator, A[] arg) {
        this.ringBuffer.publishEvents(eventTranslator, arg);
    }

    public <A, B> void publishEvent(EventTranslatorTwoArg<T, A, B> eventTranslator, A arg0, B arg1) {
        this.ringBuffer.publishEvent(eventTranslator, arg0, arg1);
    }

    public <A, B, C> void publishEvent(EventTranslatorThreeArg<T, A, B, C> eventTranslator, A arg0, B arg1, C arg2) {
        this.ringBuffer.publishEvent(eventTranslator, arg0, arg1, arg2);
    }

    public RingBuffer<T> start() {
        this.checkOnlyStartedOnce();
        for (ConsumerInfo consumerInfo : this.consumerRepository) {
            consumerInfo.start(this.executor);
        }
        return this.ringBuffer;
    }

    public void halt() {
        for (ConsumerInfo consumerInfo : this.consumerRepository) {
            consumerInfo.halt();
        }
    }

    public void shutdown() {
        try {
            this.shutdown(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e2) {
            this.exceptionHandler.handleOnShutdownException(e2);
        }
    }

    public void shutdown(long timeout, TimeUnit timeUnit) throws TimeoutException {
        long timeOutAt = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (this.hasBacklog()) {
            if (timeout < 0L || System.currentTimeMillis() <= timeOutAt) continue;
            throw TimeoutException.INSTANCE;
        }
        this.halt();
    }

    public RingBuffer<T> getRingBuffer() {
        return this.ringBuffer;
    }

    public long getCursor() {
        return this.ringBuffer.getCursor();
    }

    public long getBufferSize() {
        return this.ringBuffer.getBufferSize();
    }

    public T get(long sequence) {
        return this.ringBuffer.get(sequence);
    }

    public SequenceBarrier getBarrierFor(EventHandler<T> handler) {
        return this.consumerRepository.getBarrierFor(handler);
    }

    public long getSequenceValueFor(EventHandler<T> b1) {
        return this.consumerRepository.getSequenceFor(b1).get();
    }

    private boolean hasBacklog() {
        long cursor = this.ringBuffer.getCursor();
        for (Sequence consumer : this.consumerRepository.getLastSequenceInChain(false)) {
            if (cursor <= consumer.get()) continue;
            return true;
        }
        return false;
    }

    EventHandlerGroup<T> createEventProcessors(Sequence[] barrierSequences, EventHandler<? super T>[] eventHandlers) {
        this.checkNotStarted();
        Sequence[] processorSequences = new Sequence[eventHandlers.length];
        SequenceBarrier barrier = this.ringBuffer.newBarrier(barrierSequences);
        for (EventHandler<? super T> eventHandler : eventHandlers) {
            BatchEventProcessor<? super T> batchEventProcessor = new BatchEventProcessor<T>(this.ringBuffer, barrier, eventHandler);
            if (this.exceptionHandler != null) {
                batchEventProcessor.setExceptionHandler(this.exceptionHandler);
            }
            this.consumerRepository.add(batchEventProcessor, eventHandler, barrier);
            processorSequences[i] = batchEventProcessor.getSequence();
        }
        this.updateGatingSequencesForNextInChain(barrierSequences, processorSequences);
        return new EventHandlerGroup<T>(this, this.consumerRepository, processorSequences);
    }

    private void updateGatingSequencesForNextInChain(Sequence[] barrierSequences, Sequence[] processorSequences) {
        if (processorSequences.length > 0) {
            this.ringBuffer.addGatingSequences(processorSequences);
            for (Sequence barrierSequence : barrierSequences) {
                this.ringBuffer.removeGatingSequence(barrierSequence);
            }
            this.consumerRepository.unMarkEventProcessorsAsEndOfChain(barrierSequences);
        }
    }

    EventHandlerGroup<T> createEventProcessors(Sequence[] barrierSequences, EventProcessorFactory<T>[] processorFactories) {
        EventProcessor[] eventProcessors = new EventProcessor[processorFactories.length];
        for (int i2 = 0; i2 < processorFactories.length; ++i2) {
            eventProcessors[i2] = processorFactories[i2].createEventProcessor(this.ringBuffer, barrierSequences);
        }
        return this.handleEventsWith(eventProcessors);
    }

    EventHandlerGroup<T> createWorkerPool(Sequence[] barrierSequences, WorkHandler<? super T>[] workHandlers) {
        SequenceBarrier sequenceBarrier = this.ringBuffer.newBarrier(barrierSequences);
        WorkerPool<T> workerPool = new WorkerPool<T>(this.ringBuffer, sequenceBarrier, this.exceptionHandler, workHandlers);
        this.consumerRepository.add(workerPool, sequenceBarrier);
        Sequence[] workerSequences = workerPool.getWorkerSequences();
        this.updateGatingSequencesForNextInChain(barrierSequences, workerSequences);
        return new EventHandlerGroup<T>(this, this.consumerRepository, workerSequences);
    }

    private void checkNotStarted() {
        if (this.started.get()) {
            throw new IllegalStateException("All event handlers must be added before calling starts.");
        }
    }

    private void checkOnlyStartedOnce() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Disruptor.start() must only be called once.");
        }
    }

    public String toString() {
        return "Disruptor{ringBuffer=" + this.ringBuffer + ", started=" + this.started + ", executor=" + this.executor + '}';
    }
}

