/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.base.disruptor.dsl;

import com.bes.enterprise.base.disruptor.Sequence;
import com.bes.enterprise.base.disruptor.SequenceBarrier;
import com.bes.enterprise.base.disruptor.WorkerPool;
import com.bes.enterprise.base.disruptor.dsl.ConsumerInfo;
import java.util.concurrent.Executor;

class WorkerPoolInfo<T>
implements ConsumerInfo {
    private final WorkerPool<T> workerPool;
    private final SequenceBarrier sequenceBarrier;
    private boolean endOfChain = true;

    WorkerPoolInfo(WorkerPool<T> workerPool, SequenceBarrier sequenceBarrier) {
        this.workerPool = workerPool;
        this.sequenceBarrier = sequenceBarrier;
    }

    @Override
    public Sequence[] getSequences() {
        return this.workerPool.getWorkerSequences();
    }

    @Override
    public SequenceBarrier getBarrier() {
        return this.sequenceBarrier;
    }

    @Override
    public boolean isEndOfChain() {
        return this.endOfChain;
    }

    @Override
    public void start(Executor executor) {
        this.workerPool.start(executor);
    }

    @Override
    public void halt() {
        this.workerPool.halt();
    }

    @Override
    public void markAsUsedInBarrier() {
        this.endOfChain = false;
    }

    @Override
    public boolean isRunning() {
        return this.workerPool.isRunning();
    }
}

