/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.common.cache;

import com.bes.enterprise.common.cache.Cache;
import com.bes.enterprise.concurrent.ConcurrentLinkedHashMap;

public class ConcurrentLRUCache<K, V>
implements Cache<K, V> {
    private final ConcurrentLinkedHashMap<K, V> data;
    private final int capacity;

    public ConcurrentLRUCache(int maxCacheSize) {
        int maxCapacity;
        int initialCapacity = Math.min(256, maxCacheSize);
        this.capacity = maxCapacity = Math.min(65536, maxCacheSize);
        ConcurrentLinkedHashMap.Builder builder = new ConcurrentLinkedHashMap.Builder().initialCapacity(initialCapacity).maximumWeightedCapacity(maxCapacity);
        this.data = builder.build();
    }

    @Override
    public void add(K key, V value) {
        this.data.putIfAbsent(key, value);
    }

    @Override
    public V get(K key) {
        return this.data.get(key);
    }

    @Override
    public V remove(K key) {
        return this.data.remove(key);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void destroy() {
        this.data.clear();
    }
}

