/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.common.cache;

import com.bes.enterprise.common.cache.Cache;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
implements Cache<K, V> {
    private final LinkedHashMap<K, V> data;
    private final int capacity;

    public LRUCache(int maxCacheSize) {
        int maxCapacity;
        int initialCapacity = Math.min(256, maxCacheSize);
        this.capacity = maxCapacity = Math.min(65536, maxCacheSize);
        this.data = new LinkedHashMap(initialCapacity){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.capacity;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(K key, V value) {
        LinkedHashMap<K, V> linkedHashMap = this.data;
        synchronized (linkedHashMap) {
            this.data.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        LinkedHashMap<K, V> linkedHashMap = this.data;
        synchronized (linkedHashMap) {
            return this.data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        LinkedHashMap<K, V> linkedHashMap = this.data;
        synchronized (linkedHashMap) {
            return this.data.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        LinkedHashMap<K, V> linkedHashMap = this.data;
        synchronized (linkedHashMap) {
            return this.data.size();
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        LinkedHashMap<K, V> linkedHashMap = this.data;
        synchronized (linkedHashMap) {
            this.data.clear();
        }
    }
}

