/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.common.request.dispatcher;

import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;

public class PatternMatchUtils {
    public static final String QUERY_IDENTIFIER = "?";
    public static final String QUERY_SEPARATOR = "&";
    public static final String QUERY_PARAM_KEY_VLUE_SEPARATOR = "=";
    private static final String MULTI_PATHS_WILDCARD = "**";
    public static final char MULTI_CHAR_WILDCARD = '*';
    public static final char SIGNAL_CHAR_WILDCARD = '#';
    public static final String PATH_SEPARATOR = "/";

    public static boolean stringArrayMatches(String[] pattern, String[] compare) {
        return PatternMatchUtils.stringArrayMatches(pattern, 0, pattern.length - 1, compare, 0, compare.length - 1);
    }

    public static boolean stringArrayMatches(String[] patterns, int patternStart, int patternEnd, String[] compares, int compareStart, int compareEnd) {
        if (PatternMatchUtils.indexOfWildcard(patterns, patternStart, patternEnd) == -1) {
            return PatternMatchUtils.matchesByOrder(patterns, patternStart, patternEnd, compares, compareStart, compareEnd);
        }
        if (patternEnd == 0) {
            return true;
        }
        int matchCount = PatternMatchUtils.headMatch(patterns, patternStart, patternEnd, compares, compareStart, compareEnd);
        if (matchCount == -1) {
            return false;
        }
        patternStart += matchCount;
        if ((compareStart += matchCount) > compareEnd) {
            return PatternMatchUtils.allWildcards(patterns, patternStart, patternEnd);
        }
        if (patternStart > patternEnd) {
            return false;
        }
        matchCount = PatternMatchUtils.tailMatch(patterns, patternStart, patternEnd, compares, compareStart, compareEnd);
        if (matchCount == -1) {
            return false;
        }
        patternEnd -= matchCount;
        if (compareStart > (compareEnd -= matchCount)) {
            return PatternMatchUtils.allWildcards(patterns, patternStart, patternEnd);
        }
        matchCount = PatternMatchUtils.midAreaMatch(patterns, patternStart, patternEnd, compares, compareStart, compareEnd);
        if (matchCount == -1) {
            return false;
        }
        if ((patternStart += matchCount) == patternEnd) {
            return true;
        }
        return PatternMatchUtils.allWildcards(patterns, patternStart, patternEnd);
    }

    private static int indexOfWildcard(String[] patterns, int patternStart, int patternEnd) {
        int wildcardIndex = -1;
        for (int i2 = patternStart; i2 <= patternEnd; ++i2) {
            if (!MULTI_PATHS_WILDCARD.equals(patterns[i2])) continue;
            wildcardIndex = i2;
            break;
        }
        return wildcardIndex;
    }

    private static boolean allWildcards(String[] pattern, int patternStart, int patternEnd) {
        for (int i2 = patternStart; i2 <= patternEnd; ++i2) {
            if (pattern[i2].equals(MULTI_PATHS_WILDCARD)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesByOrder(String[] pattern, int patternBegin, int patternEnd, String[] compare, int compareBegin, int compareEnd) {
        if (patternEnd - patternBegin != compareEnd - compareBegin) {
            return false;
        }
        int compareInex = compareBegin;
        int i2 = patternBegin;
        while (i2 <= patternEnd) {
            if (!PatternMatchUtils.stringMatches(pattern[i2], compare[compareInex])) {
                return false;
            }
            ++i2;
            ++compareInex;
        }
        return true;
    }

    private static int headMatch(String[] pattern, int patternStart, int patternEnd, String[] compare, int compareStart, int compareEnd) {
        int matchCount = 0;
        int compareIndex = compareStart;
        for (int patternIndex = patternStart; patternIndex <= patternEnd && compareIndex <= compareEnd && !MULTI_PATHS_WILDCARD.equals(pattern[patternIndex]); ++patternIndex, ++compareIndex) {
            if (!PatternMatchUtils.stringMatches(pattern[patternIndex], compare[compareIndex])) {
                return -1;
            }
            ++matchCount;
        }
        return matchCount;
    }

    public static int tailMatch(String[] pattern, int patternStart, int patternEnd, String[] compare, int compareStart, int compareEnd) {
        int matchCount = 0;
        int compareIndex = compareEnd;
        for (int patternIndex = patternEnd; patternIndex >= patternStart && compareIndex >= compareStart && !MULTI_PATHS_WILDCARD.equals(pattern[patternIndex]); --patternIndex, --compareIndex) {
            if (!PatternMatchUtils.stringMatches(pattern[patternIndex], compare[compareIndex])) {
                return -1;
            }
            ++matchCount;
        }
        return matchCount;
    }

    private static int midAreaMatch(String[] pattern, int patternStart, int patternEnd, String[] compare, int compareStart, int compareEnd) {
        int patternIndex = patternStart;
        int compareIndex = compareStart;
        while (patternIndex != patternEnd && compareIndex <= compareEnd) {
            int nextWildcardIndex = PatternMatchUtils.indexOfWildcard(pattern, patternIndex + 1, patternEnd);
            if (nextWildcardIndex == patternIndex + 1) {
                ++patternIndex;
                continue;
            }
            int patternAreaLength = nextWildcardIndex - (patternIndex + 1);
            int compareAreaLength = compareEnd - compareIndex + 1;
            int foundMatchAreaEndIndex = -1;
            block1: for (int i2 = 0; i2 <= compareAreaLength - patternAreaLength; ++i2) {
                for (int j2 = 0; j2 < patternAreaLength; ++j2) {
                    if (!PatternMatchUtils.stringMatches(pattern[patternIndex + j2 + 1], compare[compareIndex + i2 + j2])) continue block1;
                }
                foundMatchAreaEndIndex = compareIndex + i2;
                break;
            }
            if (foundMatchAreaEndIndex == -1) {
                return -1;
            }
            patternIndex = nextWildcardIndex;
            compareIndex = foundMatchAreaEndIndex + patternAreaLength;
        }
        return patternIndex - patternStart;
    }

    public static boolean stringMatches(String pattern, String compare) {
        if (pattern == null || compare == null) {
            return Objects.equals(pattern, compare);
        }
        if (!PatternMatchUtils.hasWildcards(pattern)) {
            return Objects.equals(pattern, compare);
        }
        char[] patternChars = pattern.toCharArray();
        char[] compareChars = compare.toCharArray();
        return PatternMatchUtils.charArrayMatches(patternChars, 0, patternChars.length - 1, compareChars, 0, compareChars.length - 1);
    }

    public static boolean charArrayMatches(char[] patternChars, int patternStart, int patternEnd, char[] compareChars, int compareStart, int compareEnd) {
        if (PatternMatchUtils.indexOfWildcard(patternChars, patternStart, patternEnd) == -1) {
            return PatternMatchUtils.matchesByOrder(patternChars, patternStart, patternEnd, compareChars, compareStart, compareEnd);
        }
        if (patternEnd == 0) {
            return true;
        }
        int matchCount = PatternMatchUtils.headMatch(patternChars, patternStart, patternEnd, compareChars, compareStart, compareEnd);
        if (matchCount == -1) {
            return false;
        }
        patternStart += matchCount;
        if ((compareStart += matchCount) > compareEnd) {
            return PatternMatchUtils.allWildcards(patternChars, patternStart, patternEnd);
        }
        matchCount = PatternMatchUtils.tailMatch(patternChars, patternStart, patternEnd, compareChars, compareStart, compareEnd);
        if (matchCount == -1) {
            return false;
        }
        patternEnd -= matchCount;
        if (compareStart > (compareEnd -= matchCount)) {
            return PatternMatchUtils.allWildcards(patternChars, patternStart, patternEnd);
        }
        matchCount = PatternMatchUtils.midAreaMatch(patternChars, patternStart, patternEnd, compareChars, compareStart, compareEnd);
        if (matchCount == -1) {
            return false;
        }
        if ((patternStart += matchCount) == patternEnd) {
            return true;
        }
        return PatternMatchUtils.allWildcards(patternChars, patternStart, patternEnd);
    }

    private static int indexOfWildcard(char[] patternChars, int patternStart, int patternEnd) {
        int wildcardIndex = -1;
        for (int i2 = patternStart; i2 <= patternEnd; ++i2) {
            if (patternChars[i2] != '*') continue;
            wildcardIndex = i2;
            break;
        }
        return wildcardIndex;
    }

    public static boolean allWildcards(char[] chars, int start, int end) {
        for (int i2 = start; i2 <= end; ++i2) {
            if (chars[i2] == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean matchesByOrder(char[] patternChars, int patternBegin, int patternEnd, char[] compareChars, int compareBegin, int compareEnd) {
        if (patternEnd - patternBegin != compareEnd - compareBegin) {
            return false;
        }
        int compareInex = compareBegin;
        int i2 = patternBegin;
        while (i2 <= patternEnd) {
            if (patternChars[i2] != '#' && patternChars[i2] != compareChars[compareInex]) {
                return false;
            }
            ++i2;
            ++compareInex;
        }
        return true;
    }

    private static int headMatch(char[] patternChars, int patternStart, int patternEnd, char[] compareChars, int compareStart, int compareEnd) {
        int compareIndex = compareStart;
        int matchCount = 0;
        for (int patternIndex = patternStart; patternIndex <= patternEnd && compareIndex <= compareEnd && patternChars[patternIndex] != '*'; ++patternIndex, ++compareIndex) {
            if (patternChars[patternIndex] == '#') continue;
            if (patternChars[patternIndex] != compareChars[compareIndex]) {
                return -1;
            }
            ++matchCount;
        }
        return matchCount;
    }

    private static int tailMatch(char[] patternChars, int patternStart, int patternEnd, char[] compareChars, int compareStart, int compareEnd) {
        int compareIndex = compareEnd;
        int matchCount = 0;
        for (int patternIndex = patternEnd; patternIndex >= patternStart && compareIndex >= compareStart && patternChars[patternIndex] != '*'; --patternIndex, --compareIndex) {
            if (patternChars[patternIndex] == '#') continue;
            if (patternChars[patternIndex] != compareChars[compareIndex]) {
                return -1;
            }
            ++matchCount;
        }
        return matchCount;
    }

    private static int midAreaMatch(char[] patternChars, int patternStart, int patternEnd, char[] compareChars, int compareStart, int compareEnd) {
        int patternIndex = patternStart;
        int compareIndex = compareStart;
        while (patternIndex != patternEnd && compareIndex <= compareEnd) {
            int nextWildcardIndex = PatternMatchUtils.indexOfWildcard(patternChars, patternIndex + 1, patternEnd);
            if (nextWildcardIndex == patternIndex + 1) {
                ++patternIndex;
                continue;
            }
            int patternAreaLength = nextWildcardIndex - (patternIndex + 1);
            int compareAreaLength = compareEnd - compareIndex + 1;
            int foundMatchAreaEndIndex = -1;
            block1: for (int i2 = 0; i2 <= compareAreaLength - patternAreaLength; ++i2) {
                for (int j2 = 0; j2 < patternAreaLength; ++j2) {
                    if (patternChars[patternIndex + j2 + 1] != '#' && patternChars[patternIndex + j2 + 1] != compareChars[compareIndex + i2 + j2]) continue block1;
                }
                foundMatchAreaEndIndex = compareIndex + i2;
                break;
            }
            if (foundMatchAreaEndIndex == -1) {
                return -1;
            }
            patternIndex = nextWildcardIndex;
            compareIndex = foundMatchAreaEndIndex + patternAreaLength;
        }
        return patternIndex - patternStart;
    }

    public static boolean hasWildcards(String value) {
        return value.indexOf(42) != -1 || value.indexOf(35) != -1;
    }

    public static String[] split(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, separator);
        while (tokenizer.hasMoreTokens()) {
            ret.add(tokenizer.nextToken());
        }
        if (path.endsWith(separator)) {
            ret.add("");
        }
        return ret.toArray(new String[ret.size()]);
    }
}

