/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.common.request.dispatcher;

import com.bes.enterprise.common.request.dispatcher.RequestDispatcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RequestDispatcherRegistry {
    public static final String GLOBAL_REQUEST_DISPATCHER = "global-request-dispatcher";
    public static final String GLOBAL_EXCLUDE_REQUEST_DISPATCHER = "global-exclude-request-dispatcher";
    private static final Map<String, RequestDispatcher> registry = new ConcurrentHashMap<String, RequestDispatcher>();

    public static void register(String id, RequestDispatcher dispatcher) {
        if (!registry.containsKey(id)) {
            registry.put(id, dispatcher);
        }
    }

    public static Object getRequestDispatcher(String dispatcherId) {
        return registry.get(dispatcherId);
    }

    public static Object unregister(String id) {
        return registry.remove(id);
    }

    public static RequestDispatcher findRequestAllowDispatcher(String requestDispatcherId) {
        if (requestDispatcherId == null) {
            requestDispatcherId = GLOBAL_REQUEST_DISPATCHER;
        }
        return registry.get(requestDispatcherId);
    }

    public static RequestDispatcher findRequestDenyDispatcher(String requestDispatcherId) {
        if (requestDispatcherId == null) {
            requestDispatcherId = GLOBAL_EXCLUDE_REQUEST_DISPATCHER;
        }
        return registry.get(requestDispatcherId);
    }
}

