/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.digest;

import com.bes.enterprise.appserver.common.security.FileRealmHelper;
import com.bes.enterprise.appserver.common.util.CommonUtils;
import com.bes.enterprise.appserver.common.util.FileUtils;
import com.bes.enterprise.appserver.common.util.ServerLayoutConstants;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.DomTemplateParser;
import com.bes.enterprise.config.miniparser.IndentingXMLStreamWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DigestMain {
    private static final String FIELD_SEP = ";";
    private static final String COMMENT = "#";
    private static final String SSHA_256_TAG = "{SSHA256}";
    private static final String FILE_TYPE_TAG = "--type=";
    private static final String REALM_FILE = "realm";
    private static final String CONFIG_FILE = "config";
    private static final String TEMP_FILE_SUFFIX = ".temp";
    private static final String BES_HOME = System.getProperty("com.bes.installRoot");
    private static final String DEFAULT_CONFIG_FILE = BES_HOME + "/conf/" + ServerLayoutConstants.CONFIG_FILENAME;
    private static final String DEFAULT_REALM_FILE = BES_HOME + "/conf/security/keyfile";
    private static String fileType;
    private static File destinationFile;

    public static void main(String[] args) {
        try {
            boolean ok = DigestMain.parseArg(args);
            if (ok) {
                DigestMain.digest();
                System.out.println(String.format("Encrypted %s successfully.", destinationFile.getCanonicalPath()));
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
        }
    }

    private static final void digest() throws Exception {
        File tempFile = DigestMain.createTempFile();
        if (CONFIG_FILE.equals(fileType)) {
            DigestMain.digestConfigFile(tempFile);
        } else {
            DigestMain.digestRealmFile(tempFile);
        }
        File backup = new File(destinationFile.getParentFile(), destinationFile.getName() + ".bak");
        if (destinationFile.exists() && backup.exists() && !backup.delete()) {
            String msg = String.format("Could not delete previous backup file at %s.", backup.getAbsolutePath());
            throw new IOException(msg);
        }
        if (destinationFile.exists() && !FileUtils.renameFile((File)destinationFile, (File)backup)) {
            String msg = String.format("Could not rename %s to %s.", destinationFile.getAbsolutePath(), backup.getAbsolutePath());
            throw new IOException(msg);
        }
        if (!FileUtils.renameFile((File)tempFile, (File)destinationFile)) {
            String msg = String.format("Could not rename %s to %s", tempFile.getAbsolutePath(), destinationFile.getAbsolutePath());
            if (!FileUtils.renameFile((File)backup, (File)destinationFile)) {
                msg = msg + "\n" + String.format("Could not rename backup to %s.", destinationFile.getAbsolutePath());
            }
            throw new IOException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void digestConfigFile(File tempConfigFile) throws Exception {
        DomTemplate configBean = DigestMain.parseServerConfig();
        FileOutputStream fOut = null;
        XMLStreamWriter writer = null;
        try {
            fOut = new FileOutputStream(tempConfigFile);
            OutputStreamWriter encodingWriter = new OutputStreamWriter((OutputStream)fOut, "UTF-8");
            writer = XMLOutputFactory.newFactory().createXMLStreamWriter(encodingWriter);
            IndentingXMLStreamWriter indentingXMLStreamWriter = new IndentingXMLStreamWriter(writer);
            DomTemplate.persistence(indentingXMLStreamWriter, configBean);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void digestRealmFile(File tempConfigFile) throws Exception {
        BufferedReader input = null;
        BufferedWriter output = null;
        try {
            input = new BufferedReader(new FileReader(destinationFile));
            output = new BufferedWriter(new FileWriter(tempConfigFile));
            StringBuilder sb = new StringBuilder();
            while (input.ready()) {
                String line = input.readLine();
                if (!line.startsWith(COMMENT)) {
                    String[] fileds = line.split(FIELD_SEP);
                    if (fileds.length < 2 || fileds[0].isEmpty() || fileds[1].isEmpty()) {
                        throw new IllegalArgumentException("The username and password are necessary and can not be empty");
                    }
                    if (fileds.length > 3) {
                        throw new IllegalArgumentException("The realm file can only contain username, password and roles");
                    }
                    String password = fileds[1];
                    if (!password.startsWith(SSHA_256_TAG)) {
                        password = FileRealmHelper.encodePassword(password);
                    }
                    sb.append(fileds[0]).append(FIELD_SEP).append(password);
                    if (fileds.length == 3) {
                        sb.append(FIELD_SEP).append(fileds[2]);
                    }
                    line = sb.toString();
                    sb.delete(0, sb.length());
                }
                output.write(line);
                output.newLine();
                output.flush();
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final File createTempFile() throws Exception {
        String prefix = REALM_FILE.equals(fileType) ? REALM_FILE : CONFIG_FILE;
        File tempConfigFile = File.createTempFile(prefix, TEMP_FILE_SUFFIX, destinationFile.getParentFile());
        if (tempConfigFile == null) {
            throw new IOException("Failure to create temporary file!");
        }
        return tempConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DomTemplate parseServerConfig() throws IOException, XMLStreamException, FactoryConfigurationError {
        FileInputStream fIn = null;
        XMLStreamReader reader = null;
        try {
            DomTemplate domTemplate;
            fIn = new FileInputStream(destinationFile);
            reader = CommonUtils.newXMLInputFactory().createXMLStreamReader(fIn);
            DomTemplateParser parser = new DomTemplateParser();
            DomTemplate domTemplate2 = domTemplate = parser.parse(reader);
            return domTemplate2;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final boolean parseArg(String[] args) {
        boolean ok = false;
        if (args == null || args.length == 0 || args.length > 2 || !args[0].startsWith(FILE_TYPE_TAG)) {
            DigestMain.printHelp();
        } else {
            String type = args[0].substring(FILE_TYPE_TAG.length());
            if (REALM_FILE.equalsIgnoreCase(type)) {
                fileType = REALM_FILE;
            } else if (CONFIG_FILE.equalsIgnoreCase(type)) {
                fileType = CONFIG_FILE;
            } else {
                DigestMain.printHelp();
                return ok;
            }
            String filePath = null;
            filePath = args.length == 2 ? args[1] : (fileType.equals(CONFIG_FILE) ? DEFAULT_CONFIG_FILE : DEFAULT_REALM_FILE);
            destinationFile = new File(filePath);
            if (destinationFile.exists()) {
                ok = true;
            } else {
                System.out.println(String.format("The destination file %s doesn't exist.", filePath));
            }
        }
        return ok;
    }

    private static final void printHelp() {
        System.out.println("digest\r\n\r\nDESCRIPTION\r\n     Encrypt sensitive fields in file.\r\n\r\nUSAGE\r\n     digest --type=<type> [path]\r\n\r\nOPTIONS\r\n     --type\r\n         The type of the file. The type can be:\r\n\r\n         config\r\n\r\n         realm\r\n\r\nOPERANDS\r\n     path\r\n         The path of the destination file. If we do not specify the path option,\r\n         When the type is config, the default is ${BES_HOME}/conf/server.config;\r\n         When the type is realm, the default is ${BES_HOME}/conf/security/keyfile.");
    }
}

