/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.miniparser;

import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.config.miniparser.ConfigBindingException;
import com.bes.enterprise.config.miniparser.DomParserContext;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.provider.CipherAlgorithmProviderFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DomTemplateParser {
    private static final List<String> needEncryptedAttributes = new ArrayList<String>();
    private static CipherAlgorithmProviderFactory cipherAlgorithmProviderFactory = CipherAlgorithmProviderFactory.getInstance();

    public DomTemplate parse(XMLStreamReader reader) {
        return this.parse(reader, new DomParserContext());
    }

    public DomTemplate parse(XMLStreamReader reader, DomParserContext parserContext) {
        try {
            do {
                reader.next();
            } while (!reader.isStartElement());
            String navigatorPath = reader.getLocalName();
            if (!parserContext.includePath(navigatorPath)) {
                throw new ConfigBindingException(String.format("Failure to parse configration, rootElement %s is not include in paths.", navigatorPath));
            }
            DomTemplate domTemplate = this.handleElement(reader, navigatorPath, parserContext);
            return domTemplate;
        }
        catch (XMLStreamException ex) {
            throw new ConfigBindingException("Failure to parse configuration", ex);
        }
    }

    private DomTemplate handleElement(XMLStreamReader reader, String navigatorPath, DomParserContext parserContext) {
        if (reader.getEventType() != 1) {
            throw new ConfigBindingException("Current position is not START_ELEMENT.");
        }
        try {
            String localName = reader.getLocalName();
            DomTemplate domTemplate = new DomTemplate();
            domTemplate.setTagName(localName);
            this.fillAttritbutes(reader, domTemplate);
            parserContext.postFillAttributes(navigatorPath, domTemplate);
            String text = this.readText(reader, localName);
            try {
                if (cipherAlgorithmProviderFactory.isCipherText(text)) {
                    domTemplate.setEncryptedElementText(true);
                }
            }
            catch (Exception e2) {
                throw new ConfigBindingException(e2);
            }
            domTemplate.setElementText(text);
            int event = reader.getEventType();
            while (event == 1) {
                String childLocalname = reader.getLocalName();
                String childNavigatorPath = navigatorPath + "/" + childLocalname;
                if (parserContext.includePath(navigatorPath)) {
                    DomTemplate chilDomTemplate = this.handleElement(reader, childNavigatorPath, parserContext);
                    domTemplate.addElement(childLocalname, chilDomTemplate);
                } else {
                    this.skipToEnd(reader, childLocalname);
                }
                event = reader.nextTag();
            }
            parserContext.postFillElements(navigatorPath, domTemplate);
            return domTemplate;
        }
        catch (XMLStreamException ex) {
            throw new ConfigBindingException("Current position is not START_ELEMENT.", ex);
        }
    }

    private void fillAttritbutes(XMLStreamReader reader, DomTemplate domTemplate) {
        int attributeCount = reader.getAttributeCount();
        for (int i2 = 0; i2 < attributeCount; ++i2) {
            String attributeName = reader.getAttributeLocalName(i2);
            String attributeValue = reader.getAttributeValue(i2);
            try {
                if (cipherAlgorithmProviderFactory.isCipherText(attributeValue)) {
                    domTemplate.markEncryptedAttribute(attributeName);
                    attributeValue = cipherAlgorithmProviderFactory.decrypt(attributeValue);
                } else if (needEncryptedAttributes.contains(attributeName)) {
                    domTemplate.markNeedEncryptedAttribute(attributeName);
                }
            }
            catch (Exception e2) {
                throw new ConfigBindingException(String.format("Failure to decrypt attribute %s for %s.", attributeName, domTemplate.getTagName()));
            }
            domTemplate.setAttribute(attributeName, attributeValue);
        }
    }

    private String readText(XMLStreamReader reader, String localName) throws XMLStreamException {
        reader.next();
        if (reader.hasText()) {
            String text = this.readFullText(reader);
            int event = reader.getEventType();
            if (!"".equals(text.trim()) && event == 2) {
                this.skipToEnd(reader, localName);
            }
            return text;
        }
        return null;
    }

    private String readFullText(XMLStreamReader reader) throws XMLStreamException {
        StringBuilder content = new StringBuilder();
        while (reader.hasText()) {
            content.append(reader.getText());
            reader.next();
        }
        String text = content.toString();
        return text;
    }

    private void skipToEnd(XMLStreamReader reader, String name) throws XMLStreamException {
        int event;
        while ((event = reader.getEventType()) != 2 || !name.equals(reader.getLocalName())) {
            reader.next();
        }
        return;
    }

    static {
        needEncryptedAttributes.add("connection-password");
        needEncryptedAttributes.add("password");
        needEncryptedAttributes.add("key-pass");
        needEncryptedAttributes.add("keystore-pass");
        needEncryptedAttributes.add("truststore-pass");
        String needEncryptedAttributesString = System.getProperty("com.bes.enterprise.config.encrypt.additionalAttributes");
        if (!StringUtils.isEmpty((String)needEncryptedAttributesString)) {
            Set needEncryptedAttributesSet = StringUtils.parseStringSet((String)needEncryptedAttributesString, (String)",");
            for (String needEncryptedAttribute : needEncryptedAttributesSet) {
                if (needEncryptedAttributes.contains(needEncryptedAttribute)) continue;
                needEncryptedAttributes.add(needEncryptedAttribute);
            }
        }
    }
}

