/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.provider;

import com.bes.enterprise.appserver.common.util.CollectionUtils;
import com.bes.enterprise.config.provider.ConfigProvider;
import com.bes.enterprise.config.provider.ConfigProviderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigProviderFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getConfigProperites() {
        HashMap<String, String> configPropertis = new HashMap<String, String>();
        Properties providerProps = new Properties();
        String propsFileLocation = System.getProperty(ConfigProvider.PROVIDER_PROP_FILE);
        if (propsFileLocation != null) {
            File propsFile = new File(propsFileLocation);
            InputStream fIn = null;
            try {
                if (propsFile.exists()) {
                    fIn = new FileInputStream(propsFile);
                } else {
                    ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
                    fIn = contextLoader.getResourceAsStream(propsFileLocation);
                }
                if (fIn != null) {
                    providerProps.load(fIn);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (fIn != null) {
                    try {
                        fIn.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!providerProps.isEmpty()) {
            CollectionUtils.copyProperties(providerProps, configPropertis);
        }
        CollectionUtils.copyProperties(System.getProperties(), configPropertis, ConfigProvider.PROVIDER_PREFIX);
        return configPropertis;
    }

    public static ConfigProvider getConfigProvider(Map<String, String> configProperties) throws ConfigProviderException {
        String configProviderClass = configProperties.get(ConfigProvider.PROVIDER_CLASS);
        if (configProviderClass == null) {
            throw new ConfigProviderException("Missing property: " + ConfigProvider.PROVIDER_CLASS + "!");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> providerClass = loader.loadClass(configProviderClass);
            try {
                Constructor<?> constructor = providerClass.getConstructor(Map.class);
                ConfigProvider configProvider = (ConfigProvider)constructor.newInstance(configProperties);
                return configProvider;
            }
            catch (NoSuchMethodException nmEx) {
                ConfigProvider configProvider = (ConfigProvider)providerClass.newInstance();
                return configProvider;
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Could not instantiate config provider %s!", configProviderClass);
            throw new ConfigProviderException(errMsg, ex);
        }
    }
}

